/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.runtime.web;

import java.util.Map;
import org.xml.sax.Attributes;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;
import com.sun.enterprise.deployment.runtime.web.ConstraintField;
import com.sun.enterprise.deployment.xml.RuntimeTagNames;
import com.sun.enterprise.deployment.node.XMLElement;

/**
* node for cache-mapping tag
*
* @author Jerome Dochez
*/
public class ConstraintFieldNode extends WebRuntimeNode {
        
    /**
     * all sub-implementation of this class can use a dispatch table to map xml element to
     * method name on the descriptor class for setting the element value. 
     *  
     * @return the map with the element name as a key, the setter method as a value
     */
    protected Map getDispatchTable() {    
	Map dispatchTable = super.getDispatchTable();
        // for backward compatibility with S1AS 7 dtd 
	dispatchTable.put(RuntimeTagNames.VALUE, "addValue");
        dispatchTable.put(RuntimeTagNames.CONSTRAINT_FIELD_VALUE, "addValue");
	return dispatchTable;
    }

    public void startElement(XMLElement element, Attributes attributes) {
        if (element.getQName().equals(RuntimeTagNames.CONSTRAINT_FIELD)) {
            ConstraintField descriptor = 
                (ConstraintField) getRuntimeDescriptor();
            for (int i=0; i<attributes.getLength();i++) {
                if (RuntimeTagNames.NAME.equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue(ConstraintField.NAME,
                        attributes.getValue(i));
                } else 
                if (RuntimeTagNames.SCOPE.equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue(ConstraintField.SCOPE,
                        attributes.getValue(i));
                } else 
                if (RuntimeTagNames.CACHE_ON_MATCH.equals(
                    attributes.getQName(i))) {
                    descriptor.setAttributeValue(
                        ConstraintField.CACHE_ON_MATCH,
                        attributes.getValue(i));
                } else 
                if (RuntimeTagNames.CACHE_ON_MATCH_FAILURE.equals(
                    attributes.getQName(i))) {
                    descriptor.setAttributeValue(
                        ConstraintField.CACHE_ON_MATCH_FAILURE,
                        attributes.getValue(i));
                } 
            }
        // From sun-web-app_2_3-0.dtd to sun-web-app_2_4-0.dtd,
        // the element name "value" is changed to "constraint-field-value",
        // need to make sure both will work
        } else if (element.getQName().equals(RuntimeTagNames.VALUE) || 
            element.getQName().equals(RuntimeTagNames.CONSTRAINT_FIELD_VALUE)) {
            ConstraintField descriptor = 
                (ConstraintField) getRuntimeDescriptor();
            int index = descriptor.sizeValue();
            for (int i=0; i<attributes.getLength();i++) {
                if (RuntimeTagNames.MATCH_EXPR.equals(
                    attributes.getQName(i))) {
                    descriptor.setAttributeValue(ConstraintField.VALUE, 
                        index, ConstraintField.MATCH_EXPR,
                        attributes.getValue(i));
                } else 
                if (RuntimeTagNames.CACHE_ON_MATCH.equals(
                    attributes.getQName(i))) {
                    descriptor.setAttributeValue(ConstraintField.VALUE, 
                        index, ConstraintField.CACHE_ON_MATCH,
                        attributes.getValue(i));
                } else 
                if (RuntimeTagNames.CACHE_ON_MATCH_FAILURE.equals(
                    attributes.getQName(i))) {
                    descriptor.setAttributeValue(ConstraintField.VALUE, 
                        index, ConstraintField.CACHE_ON_MATCH_FAILURE,
                        attributes.getValue(i));
                } 
            }
        } else super.startElement(element, attributes);
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name 
     * @param the array of descriptor to write
     * @return the DOM tree top node
     */    
    public void writeDescriptor(Node parent, String nodeName, ConstraintField[] descriptors) {
	for (int i=0;i<descriptors.length;i++) {
	    writeDescriptor(parent, nodeName, descriptors[i]);
	}
    }
    
    /**
     * write the descriptor class to a DOM tree and return it
     *
     * @param parent node for the DOM tree
     * @param node name 
     * @param the descriptor to write
     * @return the DOM tree top node
     */    
    public Node writeDescriptor(Node parent, String nodeName, ConstraintField descriptor) {
	
	Element constraintField = (Element) super.writeDescriptor(parent, nodeName, descriptor);
	
	// value*
	String[] values = descriptor.getValue();
	for (int i=0;i<values.length;i++) {
	    Element value = (Element) appendTextChild(constraintField, RuntimeTagNames.CONSTRAINT_FIELD_VALUE, values[i]);
	    setAttribute(value, RuntimeTagNames.MATCH_EXPR, (String) descriptor.getAttributeValue(ConstraintField.VALUE, i, ConstraintField.MATCH_EXPR));
	    setAttribute(value, RuntimeTagNames.CACHE_ON_MATCH, (String) descriptor.getAttributeValue(ConstraintField.VALUE, i, ConstraintField.CACHE_ON_MATCH));
	    setAttribute(value, RuntimeTagNames.CACHE_ON_MATCH_FAILURE, (String) descriptor.getAttributeValue(ConstraintField.VALUE, i, ConstraintField.CACHE_ON_MATCH_FAILURE));
	    
	}
	// name, scope, cache-on-match, cache-on-match-failure attributes        
	setAttribute(constraintField, RuntimeTagNames.NAME, (String) descriptor.getAttributeValue(ConstraintField.NAME));
	setAttribute(constraintField, RuntimeTagNames.SCOPE, (String) descriptor.getAttributeValue(ConstraintField.SCOPE));        
	setAttribute(constraintField, RuntimeTagNames.CACHE_ON_MATCH, (String) descriptor.getAttributeValue(ConstraintField.CACHE_ON_MATCH));
	setAttribute(constraintField, RuntimeTagNames.CACHE_ON_MATCH_FAILURE, (String) descriptor.getAttributeValue(ConstraintField.CACHE_ON_MATCH_FAILURE));
	
	return constraintField;	
    }
}
