/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.node.web;

import com.sun.enterprise.deployment.xml.WebTagNames;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.WebBundleDescriptor;


import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.web.URLPattern;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.Level;

/**
 * This node is responsible for handling servlet-mapping subtree node
 *
 * @author  Jerome Dochez
 * @version 
 */
public class ServletMappingNode extends DeploymentDescriptorNode {

    private String servletName;
    private String urlPattern;

    private static LocalStringManagerImpl localStrings =
            new LocalStringManagerImpl(ServletMappingNode.class);

    /**
     * receives notiification of the value for a particular tag
     * 
     * @param element the xml element
     * @param value it's associated value
     */    
    public void setElementValue(XMLElement element, String value) {
        if (WebTagNames.SERVLET_NAME.equals(element.getQName())) {
            servletName = value;
        } 
        if (WebTagNames.URL_PATTERN.equals(element.getQName())) {
            // If URL Pattern does not start with "/" then 
            // prepend it (for Servlet2.2 Web apps) 
            Object parent = getParentNode().getDescriptor(); 
            if (parent instanceof WebBundleDescriptor &&  
                ((WebBundleDescriptor) parent).getSpecVersion().equals("2.2")) 
            { 
                if(!value.startsWith("/") && !value.startsWith("*.")) { 
                    value = "/" + value; 
                } 
            } 
            urlPattern = value;
            if (!URLPattern.isValid(urlPattern)) {
                throw new IllegalArgumentException(localStrings.getLocalString(
                "enterprise.deployment.invalidurlpattern", 
                "Invalid URL Pattern: [{0}]",
                new Object[] {urlPattern}));
            }

            XMLNode  parentNode = getParentNode();
            if (parentNode instanceof WebBundleNode) {
                ((WebBundleNode) parentNode).addServletMapping(servletName, 
                urlPattern);
            } else {
                DOLUtils.getDefaultLogger().log(Level.SEVERE, "enterprise.deployment.backend.addDescriptorFailure",
                    new Object[]{getXMLRootTag() , "servlet-mapping"});
            }

        } 
    }
    
        
   /**
    * @return the descriptor instance to associate with this XMLNode
    */    
    public Object getDescriptor() {
        return null;
    }
}
