/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.runtime.web;

import com.sun.enterprise.deployment.runtime.RuntimeDescriptor;

/**
* this class contains runtime information for the web bundle 
* it was kept to be backward compatible with the schema2beans descriptors
* generated by iAS 7.0 engineering team.
*
* @author Jerome Dochez
*/
public class ConstraintField extends RuntimeDescriptor
{
    
    static public final String VALUE = "Value";	// NOI18N
    static public final String NAME = "Name";
    static public final String SCOPE = "Scope";    
    static public final String MATCH_EXPR = "MatchExpr";
    static public final String CACHE_ON_MATCH = "CacheOnMatch";
    static public final String CACHE_ON_MATCH_FAILURE = "CacheOnMatchFailure";
        
    public ConstraintField(ConstraintField other)
    {
	super(other);
    }

    public ConstraintField()
    {
	setAttributeValue(SCOPE, "request.parameter");
	setAttributeValue(CACHE_ON_MATCH, "true");
	setAttributeValue(CACHE_ON_MATCH_FAILURE, "false");  
    }
    
    // This attribute is an array, possibly empty
    public void setValue(int index, String value)
    {
	this.setValue(VALUE, index, value);
    }
    
    //
    public String getValue(int index)
    {
	return (String)this.getValue(VALUE, index);
    }
    
    // This attribute is an array, possibly empty
    public void setValue(String[] value)
    {
	this.setValue(VALUE, value);
    }
    
    //
    public String[] getValue()
    {
	return (String[])this.getValues(VALUE);
    }
    
    // Return the number of properties
    public int sizeValue()
    {
	return this.size(VALUE);
    }
    
    // Add a new element returning its index in the list
    public int addValue(String value)
    {
	int index = this.addValue(VALUE, value);
	if (getAttributeValue(VALUE, index, MATCH_EXPR)==null)
	    setAttributeValue(VALUE, index, MATCH_EXPR, "equals");
	if (getAttributeValue(VALUE, index, CACHE_ON_MATCH)==null)	    
	    setAttributeValue(VALUE, index, CACHE_ON_MATCH, "true");
	if (getAttributeValue(VALUE, index, CACHE_ON_MATCH_FAILURE)==null)	    
	    setAttributeValue(VALUE, index, CACHE_ON_MATCH_FAILURE, "false");
	return index;
    }
    
    //
    // Remove an element using its reference
    // Returns the index the element had in the list
    //
    public int removeValue(String value)
    {
	return this.removeValue(VALUE, value);
    }
    
    // This method verifies that the mandatory properties are set
    public boolean verify()
    {
	return true;
    }
}
