/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.types;

import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.Descriptor;

/** 
 * 
 *
 * @author Kenneth Saks
 */

public interface MessageDestinationReferencer {

    /**
     * @return true if this referencer is linked to a message destination
     * and false otherwise.
     */
    public boolean isLinkedToMessageDestination();

    /** 
     * Gets the link name of the reference. Points to the associated
     * message destination within the J2EE application. Can be NULL
     * if link is not set.
     * @return the link name.
     */
    public String getMessageDestinationLinkName();

    /** 
     * Sets the link name of the reference. Points to the associated
     * message destination within the J2EE application.  Can be NULL
     * if link is not set.
     * @param the link name.
     */
    public void setMessageDestinationLinkName(String linkName);
    
    /** 
     * Sets the name of the message destination to which I refer.
     * @param resolve if true,  *try* to resolve link to the target message
     * destination.  
     *
     * @return MessageDestination to which link was resolved, or null if 
     * link name resolution failed.
     */
    public MessageDestinationDescriptor setMessageDestinationLinkName
        (String linkName, boolean resolve);

    /** 
     * Try to resolve the current link name value to a MessageDestination
     * object.
     *
     * @return MessageDestination to which link was resolved, or null if 
     * link name resolution failed.
     */
    public MessageDestinationDescriptor resolveLinkName();

    /**
     * @return the message destination object to which this message destination
     * ref is linked.  Can be NULL.
     */
    public MessageDestinationDescriptor getMessageDestination();

    /**
     * @param destination set the message destination object to which this 
     * message destination ref is linked.  Can be NULL.
     * 
     */
    public void setMessageDestination(MessageDestinationDescriptor destination);

    /**
     * True if the owner is a message destination reference.
     */ 
    public boolean ownedByMessageDestinationRef();

    /**
     * Get the descriptor for the message destination reference owner.
     */ 
    public MessageDestinationReferenceDescriptor getMessageDestinationRefOwner
        ();

    /**
     * True if the owner is a message-driven bean.
     */ 
    public boolean ownedByMessageBean();

    /**
     * Get the descriptor for the message-driven bean owner.
     */ 
    public EjbMessageBeanDescriptor getMessageBeanOwner();

}

