/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.util;

import java.io.File;
import java.io.FilenameFilter;   

 /**
 * Filename filter allowing files ending with the specified extensions (with period)
 * and all directories.
 *
 *
 * @author Danny Coward 
 **/

public class SimpleFilenameFilter implements FilenameFilter {
    private String[] extensions = {};
    
    public SimpleFilenameFilter(String[] extensions) {
	this.extensions = extensions;
    }

    public boolean accept(File pathname, String s) {
	if ( (new File(pathname, s)).isDirectory() ) {
	    return true;
	} else {
	    if (extensions == null) {
		return true;
	    }
	}
	for (int i = 0; i < extensions.length; i++) {
	    if ( s.endsWith(extensions[i]) ) {
		return true;
	    }
	}
	return false;
    
    }
}

