/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TriStateBool.java
 *
 * Created on March 14, 2003, 5:21 PM
 */

package com.sun.enterprise.util;

/**
 *
 * @author  bnevins
 */
/** This class is a Java Enum for a bool value that also has an "undefined" state.
 **/

public class TriStateBool
{
	private TriStateBool()
	{
	}

	//////////////////////////////////////////////////////////////////////////
	
	/** Convert a String into one of the three possible TriStateBool instances.
	 * It does a case-insensitive string comparison:
	 * <p>
	 * "true" --> TRUE
	 * "false" --> FALSE
	 * anything-else --> UNDEFINED
	 * @param s String representation of the TriStateBool
	 * @return One of the 3 possible values
	 */	
	public static final TriStateBool	translate(String s)
	{
		if(StringUtils.ok(s))
		{
			s = s.toLowerCase();

			if(s.equals("true"))
				return TRUE;
			if(s.equals("false"))
				return FALSE;
		}
		return UNDEFINED;
	}

	//////////////////////////////////////////////////////////////////////////
	
	public String toString()
	{
		if(this == TRUE)
			return "TRUE";
		else if(this == FALSE)
			return "FALSE";
		if(this == UNDEFINED)
			return "UNDEFINED";
		else
			return "IMPOSSIBLE VALUE!!";
	}
	
	//////////////////////////////////////////////////////////////////////////
	
	public static final TriStateBool	TRUE		= new TriStateBool();
	public static final TriStateBool	FALSE		= new TriStateBool();
	public static final TriStateBool	UNDEFINED	= new TriStateBool();	

	//////////////////////////////////////////////////////////////////////////
	
	public static void main(String[] args)
	{
		System.out.println("TruE: " + translate("TruE"));
		System.out.println("FALse: " + translate("FALse"));
		System.out.println("TruEX: " + translate("TruEX"));
	}

}
