/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.util;

/**
 * A unique value generator is used to generate numbers
 * that are guaranteed to be unique within a particular
 * scope and lifetime of a J2EE server. See below for details.
 * Generators support concurrent access.  Each generator
 * generates unique numbers within a particular context.
 * Clients that need to draw numbers from the same "bucket"
 * must use the same context.  
 *
 * @author Kenneth Saks
 */
public interface UniqueValueGenerator {

    /**
     * Generate a number that is guaranteed to be unique
     * within the lifetime of one J2EE server instance
     * on one machine.(in both single-vm and multi-vm modes)
     * That is, between "j2ee -start" and "j2ee -stop".
     * @exception UniqueValueGeneratorException if error occurs
     */
    long nextNumber() throws UniqueValueGeneratorException;

    /**
     * Generate an id that is guaranteed to be unique across
     * multiple sessions of the same j2ee server on the same machine.
     * @exception UniqueValueGeneratorException if error occurs
     */
    String nextId() throws UniqueValueGeneratorException;

    /**
     * Get the context within which unique numbers will be generated.
     */
    String getContext() throws UniqueValueGeneratorException;

}
