/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ProfilerImpl.java
 *
 * Created on September 17, 2001, 12:42 PM
 */

package com.sun.enterprise.util.diagnostics;

import java.util.*;
import com.sun.enterprise.util.diagnostics.Reporter;
import com.sun.enterprise.util.StringUtils;

/** Simple class for profiling code.  beginItem/endItem pairs start and stop the timing for an item.  
 *
 * @author  bnevins
 * @version 
 */


public class ProfilerImpl 
{
	/** Create an empty object
	 */
	public ProfilerImpl() 
	{
    }

	/**Reset all the timing information
	 */
	public void reset()
	{
		currItem		= null;
		items.clear();
		numBegins		= 0;
		numEnds			= 0;
		numActualEnds	= 0;
	}	
	/** Start timing an item.
	 **/
	public void beginItem()
	{
		beginItem("No Description");
	}

	/** Start timing an item.
	 * @param desc - Descriptive text for the item 
	 **/	
	public void beginItem(String desc)
	{
		//if(currItem != null)
			//Reporter.assert(currItem.hasEnded());
		
		currItem = new Item(desc);
		items.add(currItem);
		++numBegins;
	}
	/** Stop timing an item and store the information.
	 **/
	public void endItem()
	{
		++numEnds;
		Item item = getLastNotEnded();
		
		if(item != null)
			item.end();
		++numActualEnds;
	}
	/** Return a formatted String with the timing information
	 **/
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("\nBegins: " + numBegins + ", Ends: " + numEnds + 
				", Actual Ends: " + numActualEnds + "\n");
		
		sb.append(Item.getHeader());
		sb.append("\n");

		
		for(Iterator iter = items.iterator(); iter.hasNext(); )
		{
			Item item = (Item)iter.next();
			sb.append(item.toString());
			sb.append("\n");
		}
		return sb.toString();
	}
	
	////////////////////////////////////////////////////////////////////////////
	
	private Item getLastNotEnded()
	{
		int index = items.size();
		
		while(--index >= 0)
		{
			Item item = (Item)items.get(index);
			
			if(!item.hasEnded())
				return item;
		}
		return null;
	}
	
	////////////////////////////////////////////////////////////////////////////
	
	private static class Item
	{
		Item(String desc)
		{
			title		= desc;
			startTime	= System.currentTimeMillis();
			endTime		= startTime;
			
			if(title.length() > longestTitle)
				longestTitle = title.length();
		}
		
		boolean hasEnded()
		{
			return ended;
			//return endTime > startTime;
		}
		
		void end()
		{
			endTime	= System.currentTimeMillis();
			ended = true;
		}
		
		public String toString()
		{
			long finish = hasEnded() ? endTime : System.currentTimeMillis();
			
			String totalTime = "" + (finish - startTime);
			
			if(totalTime.equals("0"))
				totalTime = "< 1";

			String desc = StringUtils.padRight(title, longestTitle + 1);
			String time = StringUtils.padLeft(totalTime, 8);

			if(!hasEnded())
				time += "  ** STILL RUNNING **";
			
			return desc + time;
		}
		
		public static String getHeader()
		{
			return "\n" + StringUtils.padRight("Description", longestTitle + 1) + StringUtils.padLeft("msec", 8);
		}
		
		String		title;
		long		startTime;
		long		endTime;
		static int	longestTitle	= 12;
		boolean		ended			= false;
	}
	
	////////////////////////////////////////////////////////////////////////////
	
	Item	currItem		= null;
	List	items			= new ArrayList();
	int		numBegins		= 0;
	int		numEnds			= 0;
	int		numActualEnds	= 0;
	
	////////////////////////////////////////////////////////////////////////////
	/** Simple unit test
	 **/
	public static void main(String[] notUsed)
	{
		ProfilerImpl p = new ProfilerImpl();
		
		try
		{
			p.beginItem("first item");
			Thread.sleep(3000);
			p.beginItem("second item here dude whoa yowser yowser");
			Thread.sleep(1500);
			p.endItem();
			p.endItem();
			System.out.println("" + p);
		}
		catch(Exception e)
		{
		}
	}
}
