package com.sun.enterprise.util.diagnostics;

import java.io.*;
import java.util.*;
/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * The class <code>StackTrace</code> is a simple class -- its toString() method generates a stack trace
 * @author Byron Nevins
 * @see com.elf.diagnostics.Reporter
 * @since iAB 6.0
 */

public class StackTrace
{
    /** Creates a new StackTrace object, which is based at the execution location.
     *
     * This is useful for finding out who called a function.
     */    
	public StackTrace()
	{
		throwable = new Throwable();
	}

        /** create a stackTrace object for the given Throwable
         * @param t The Throwable that you are interested in.
         */        
	public StackTrace(Throwable t)
	{
		throwable = t;
	}

        /** Used by the Reporter class
         * @return The text of a stack trace.
         * @see Reporter
         */        
	public String toString()
	{
		ByteArrayOutputStream	baos	= new ByteArrayOutputStream();
		PrintWriter				pw		= new PrintWriter(baos);

		// create the stack trace
		throwable.printStackTrace(pw);
		pw.flush();
		return baos.toString();
	}
	
        /** This really should be private.  Do not use this.
         */        
	Throwable throwable = null;
}

