/*
 * NativeUtils.java
 *
 * Created on October 28, 2006, 10:28 PM
 *
 */

package com.sun.enterprise.util.natives;

/**
 * This class is the place to put any utility functions called in native code.
 * @author bnevins
 */
public class NativeUtils
{
    /**
     * native function to get a String from stdin without echoing the characters.
     * Note that the native code will be derprecated once JDK 1.6 is required.
     * @return The String the user types in
     */
    public native String getPasswordNative();
    
    static 
    {
        System.loadLibrary("cliutil");
    }
    
    ///////////////////////////////////////////////////////////////////////////
    
    /**
     * Convenience method.  Print the prompt and then get the user's input
     * @param prompt Prompt string to display on stdout
     * 
     * @return The String the user types in
     */
    static public String getPassword(String prompt)
    {
        if(prompt != null && prompt.length() > 0)
            System.out.print(prompt);
        
        return getPassword();
    }
    
    ///////////////////////////////////////////////////////////////////////////
    
    /**
     * Get the user's input
     * @return The String the user types in
     */
    static public String getPassword()
    {
        return new NativeUtils().getPasswordNative();
    }
}
