/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.webservice.monitoring;

import java.lang.reflect.Method;

/**
 * Factory for the WebServiceEngine 
 *
 * @author Jerome Dochez
 */
public class WebServiceEngineFactory {
    
    private static WebServiceEngineFactory _factory = null;
    
    private final WebServiceEngine engine;
    
    /** Creates a new instance of WebServiceEngineFactory */
    protected WebServiceEngineFactory() {
        // build-order problem--have to use reflection
        try {
            final ClassLoader classLoader   = Thread.currentThread().getContextClassLoader();
            final Class engineClass =
                classLoader.loadClass( "com.sun.enterprise.webservice.monitoring.WebServiceEngineImpl" );
            final java.lang.reflect.Method m  = engineClass.getDeclaredMethod( "getInstance", (Class[])null);
            engine  = (WebServiceEngine)m.invoke( null, (Object[])null );
        }
        catch( final Exception e ) {
            throw new Error( e );
        }
    }
    
    /**
     * @return the singleton Factory implementation
     */
    public static synchronized WebServiceEngineFactory getInstance() {
        if (_factory==null) {
            _factory = new WebServiceEngineFactory();
        }
        return _factory;
    }
    
    /**
     * @return this appserver WebServiceEngine instance
     */
    public WebServiceEngine getEngine() {
        return engine;
    }   
}
