/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.naming;

import java.util.List;

import com.sun.corba.ee.spi.folb.GroupInfoServiceObserver;
import com.sun.corba.ee.spi.folb.GroupInfoService;
import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.impl.orbutil.ORBConstants;

import com.sun.enterprise.util.ORBManager;
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;


/**
 * Called when the GroupInfoService that you register with
 * has a change.  You should call the GroupInfoService
 * <code>getClusterInstanceInfo</code> method to get
 * updated info.
 * @author Sheetal Vartak
 */
public class GroupInfoServiceObserverImpl 
    implements GroupInfoServiceObserver {

    protected final Logger _logger = LogDomains.getLogger(
					   LogDomains.JNDI_LOGGER);  
    private GroupInfoService gis;

    public GroupInfoServiceObserverImpl(GroupInfoService gis) {
	this.gis = gis;
    }

    public void membershipChange() {

	try {	 	    
	    List<ClusterInstanceInfo> instanceInfoList = gis.getClusterInstanceInfo((String[])null);
	    
	    S1ASCtxFactory.getRRPolicy().setClusterInstanceInfo(instanceInfoList);
	} catch(Exception e) {
	    _logger.log(Level.SEVERE, "groupinfoservice.membership.notification.problem", new Object[] {e.getMessage()});
	}
    }

}
