/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.appserv.naming;

import javax.naming.spi.InitialContextFactory;
import javax.naming.*;

import java.util.Hashtable;

import org.omg.CORBA.ORB;

import com.sun.corba.ee.impl.orbutil.ORBConstants;
import com.sun.corba.ee.spi.folb.GroupInfoService;

import com.sun.jndi.cosnaming.CNCtxFactory;

import com.sun.enterprise.naming.SerialContext;
import com.sun.enterprise.util.ORBManager;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;

/**
 * Implements the JNDI SPI InitialContextFactory interface used to
 * create the InitialContext objects.
 *
 * The static block creates the list of endpoints from the system property
 * com.sun.appserv.iiop.endpoints.
 * The list is randomised the very first time S1ASCtxFactory is initialized.
 * When a call for a new InitialContext comes, the pointer in the list is moved 
 * one element ahead. Thus for loadbalancing purposes, there is always a different 
 * list created.
 * failover is taken care of by the ORB infrastructure.
 *
 * @author Dhiru Pandey & Vijay Raghavan
 * @author Sheetal Vartak
 */

public class S1ASCtxFactory extends CNCtxFactory {    

    protected static Logger _logger = LogDomains.getLogger(
					   LogDomains.JNDI_LOGGER);    

    private static RoundRobinPolicy rrPolicy = null;

    private static final String IIOP_URL = "iiop:1.2@";

    private static final String CORBALOC = "corbaloc:";

    public static final String LOAD_BALANCING_PROPERTY = 
            "com.sun.appserv.iiop.loadbalancingpolicy";

    public static final String IIOP_ENDPOINTS_PROPERTY = 
            "com.sun.appserv.iiop.endpoints";

    private Hashtable defaultEnv;

    private static GroupInfoService gis;

    public static final String IC_BASED_WEIGHTED = "ic-based-weighted";

    public static final String IC_BASED = "ic-based";

    static {    
	String [] list = null;
	String [] commaDelimitedValues = null;
	String policy = null;
      
	// Get the load balancing policy
	String propertyValue = System.getProperty(
			              LOAD_BALANCING_PROPERTY);

	if (propertyValue != null) {
	    commaDelimitedValues = propertyValue.split(",");
	    
	    
	    if (commaDelimitedValues != null) {
		if (commaDelimitedValues[0].trim().equals(IC_BASED) ||
		    commaDelimitedValues[0].trim().equals(IC_BASED_WEIGHTED)) {
		    policy = commaDelimitedValues[0];
		}
	    }
	    if(policy != null) {
		System.setProperty(LOAD_BALANCING_PROPERTY, policy);
	    }
	}
	
	propertyValue = System.getProperty(
					   IIOP_ENDPOINTS_PROPERTY);
	
	if(propertyValue==null||propertyValue.length()==0){
	  //do not use the defaults here as then we are not giving a 
	  //chance to the <policy>,host:port(,host:port)* type of policy
	  //specification
	    list = null;
	} else {
	    list = propertyValue.split(",");	    
	}
            
	//if the endpoints property was not specified, give a
	//chance to the <policy>,host:port(,host:port)* type of policy
	//specification
	if(list == null ) {
	    if (commaDelimitedValues != null && 
		commaDelimitedValues.length > 1) {
	        
	        list = new String[commaDelimitedValues.length-1];
		for (int i=0; i<list.length; i++) {
		    list[i] = commaDelimitedValues[i+1];
		}		
	    } 
	}
	
	rrPolicy = new RoundRobinPolicy(list);
	
	try {
	    //bug 6311845
	    // remove the list_initial_services part once the bug gets fixed.
	    String[] services = (ORBManager.getORB()).list_initial_services();
	    //for (int i = 0; i < str.length; i++) {
	    for (String str : services) {
		if (str.equals(ORBConstants.FOLB_CLIENT_GROUP_INFO_SERVICE)) {
		    //lookup the GroupInfoService and register with it
		    gis = (GroupInfoService) ((ORBManager.getORB()).resolve_initial_references(ORBConstants.FOLB_CLIENT_GROUP_INFO_SERVICE));
		    gis.addObserver(new GroupInfoServiceObserverImpl(gis));
		    break;
		}
	    }

	    //log at fine if gis not present
	    if (gis == null) {
		_logger.fine("GroupInfoService not available. This is PE");
	    }

	} catch(Exception e) {
	    _logger.log(Level.WARNING, "groupinfoservice.lookup.problem", new Object[] {e.getMessage()});
	}
    }

    public S1ASCtxFactory() {
        defaultEnv = new Hashtable();
    }

    public S1ASCtxFactory(Hashtable env) {
        defaultEnv = env;
    }

    public static RoundRobinPolicy getRRPolicy() {
	return rrPolicy;
    }

    public Context getInitialContext(Hashtable env) throws NamingException {
        
	String policy = null;

        if (SerialContext.getSticky() != null) {
	    Context ctx = SerialContext.getStickyContext();	
	    return ctx;
	}

	if (env == null) {
	    env = defaultEnv;
	}
	
        //user can specify the load balancing policy and endpoints
        // via env. Hence the logic below. 
      
        String propertyValue = (String) env.get(LOAD_BALANCING_PROPERTY);
	String[] commaDelimitedValues = null;
	String host = null;
	String port = null;

	if (propertyValue != null) {
	    commaDelimitedValues = propertyValue.split(",");	

	    if (commaDelimitedValues != null) {
		if (commaDelimitedValues[0].trim().equals(IC_BASED) ||
		    commaDelimitedValues[0].trim().equals(IC_BASED_WEIGHTED)) {
		    policy = commaDelimitedValues[0];
		}
	    }
	    if (policy != null) {
		System.setProperty(LOAD_BALANCING_PROPERTY, policy);
	    }
	}
	
	propertyValue = (String) env.get(IIOP_ENDPOINTS_PROPERTY);

	String [] temp_list = (propertyValue == null || 
			  propertyValue.length() == 0)
	                  ? null 
	                  : propertyValue.split(",");
	if(temp_list == null || temp_list.length == 0) {
	    if (commaDelimitedValues != null) {
	        temp_list = new String[commaDelimitedValues.length - 1];
	  
		for (int i=0; i<temp_list.length; i++) {
		    temp_list[i] = commaDelimitedValues[i+1];
		}
	    }	    	
	}
        //if endpoints property is not set by commandline or via env
        // check for JNDI provider url
        // else use ORB host:port value
	if ((System.getProperty(IIOP_ENDPOINTS_PROPERTY) == null) &&
	    (temp_list == null || 
	     temp_list.length == 0)) {
	    if (env.get(ORBManager.JNDI_PROVIDER_URL_PROPERTY) != null) {
		temp_list = rrPolicy.getEndpointForProviderURL(
		    (String)env.get(ORBManager.JNDI_PROVIDER_URL_PROPERTY));
	    }
	    if (temp_list == null || temp_list.length == 0) {
		if (env.get(ORBManager.OMG_ORB_INIT_HOST_PROPERTY) != null &&
		    env.get(ORBManager.OMG_ORB_INIT_PORT_PROPERTY) != null) {
		    host = (String)env.get(
			ORBManager.OMG_ORB_INIT_HOST_PROPERTY);
		    port = (String)env.get(
			ORBManager.OMG_ORB_INIT_PORT_PROPERTY);
		} else {
		    host = System.getProperty(
			ORBManager.OMG_ORB_INIT_HOST_PROPERTY);
		    port = System.getProperty(
			ORBManager.OMG_ORB_INIT_PORT_PROPERTY);
		}
		if (host != null &&
		    port != null) {
		    temp_list = rrPolicy.getAddressPortList(host, port);	 
		    _logger.log(Level.WARNING, "no.endpoints.selected", 
				new Object[] {host, port});
		} else {	  
		    _logger.log(Level.SEVERE, "no.endpoints");
		    throw new RuntimeException("Cannot Proceed. No Endpoints specified.");
		}
	    }	    
	}
	
	//add the list after randomising it to the circular list in rrPolicy
	if (temp_list != null && temp_list.length > 0) {
	    rrPolicy.setClusterInstanceInfo(temp_list);
	} 
	
	//get next version of the randomized list using round robin algo
	Object [] list = rrPolicy.getNextRotation();
	
	if (_logger.isLoggable(Level.FINE)) {
	    rrPolicy.print();
	}
	
	String corbalocURL = "";
	
	//convert list into corbaloc url
	for (int i = 0; i < list.length;i++) {
	    _logger.fine("list[i] ==> " + list[i]);
	    if (corbalocURL.equals("")) {
	        corbalocURL = IIOP_URL + ((String)list[i]).trim();
	    } else {
	        corbalocURL = corbalocURL + "," +
		    IIOP_URL + ((String)list[i]).trim();
	    }
	}	
	_logger.fine("corbaloc url ==> " + corbalocURL);

	env.put("com.sun.appserv.ee.iiop.endpointslist", 
		CORBALOC + corbalocURL);	
	env.put(ORBManager.JNDI_CORBA_ORB_PROPERTY, ORBManager.getORB());
	
	return new SerialContext(env);
    }   
}
