/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.base.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import java.util.logging.*;
import com.sun.logging.*;

import com.sun.ejb.spi.container.ContainerCallback;
import com.sun.ejb.spi.io.J2EEObjectStreamFactory;
import com.sun.ejb.spi.io.NonSerializableObjectHandler;

public class IOUtils {

    private static final Logger _ejbLogger =
       LogDomains.getLogger(LogDomains.EJB_LOGGER);

    private static J2EEObjectStreamFactory _streamFactory;

    public static final void setJ2EEObjectStreamFactory(
            J2EEObjectStreamFactory  factory)
    {
        _streamFactory = factory;
    }
    
    public static ObjectInputStream createObjectInputStream(
	    final InputStream is, final boolean resolveObject,
	    final ClassLoader loader)
	throws Exception
    {
	return _streamFactory.createObjectInputStream(is, resolveObject, loader);
    }

    public static ObjectOutputStream createObjectOutputStream(
	    final OutputStream os, final boolean replaceObject,
	    final NonSerializableObjectHandler handler)
	throws IOException
    {
	return _streamFactory.createObjectOutputStream(os, replaceObject,
		handler);
    }

    public static final byte[] serializeObject(Object obj, boolean replaceObject)
	throws java.io.NotSerializableException, java.io.IOException
    {
        byte[] data = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = _streamFactory.createObjectOutputStream(
                bos, replaceObject,
                new NonSerializableObjectHandler() {
                    public Object handleNonSerializableObject(Object obj) {
                        return obj;
                    }
                });

            oos.writeObject(obj);
            oos.flush();
            data = bos.toByteArray();
        } catch (java.io.NotSerializableException notSerEx) {
            throw notSerEx;
        } catch (Exception th) {
            IOException ioEx = new IOException(th.toString());
            ioEx.initCause(th);
            throw ioEx;
        } finally {
            if (oos != null) {
                try { oos.close(); } catch (Exception ex) {}
            }
            try { bos.close(); } catch (Exception ex) {}
        }

	return data;
    }

    public static final Object deserializeObject(byte[] data, boolean resolveObject,
            ClassLoader classLoader)
	throws Exception
    {
        Object obj = null;
	ByteArrayInputStream bis = null;
	ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(data);
            ois = _streamFactory.createObjectInputStream(bis, resolveObject,
		    classLoader);
            obj = ois.readObject();
        } catch (Exception ex) {
            _ejbLogger.log(Level.FINE, "Error during deserialization", ex);
            throw ex;
        } finally {
            try { ois.close(); } catch (Exception ex) {
                _ejbLogger.log(Level.FINEST, "Error during ois.close()", ex);
            }
            try { bis.close(); } catch (Exception ex) {
                _ejbLogger.log(Level.FINEST, "Error during bis.close()", ex);
            }
	}
        return obj;
    }

}
