/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.ejb.containers;

import com.sun.ejb.*;
import com.sun.ejb.portable.*;
import com.sun.enterprise.*;
import com.sun.enterprise.deployment.*;
import java.lang.reflect.Method;

import javax.ejb.*;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.NoSuchObjectException;

import java.util.Hashtable;
import java.util.Properties;

import java.util.logging.*;
import com.sun.logging.*;

/**
 * This class implements the EJBHome interface.
 * This class is also the base class for all generated concrete EJBHome
 * implementations.
 * At deployment time, one instance of the EJBHome is created
 * for each EJB class in a JAR that has a remote home.
 *
 */

public abstract class EJBHomeImpl
    implements javax.ejb.EJBHome
{

    private static final Logger _logger =
        LogDomains.getLogger(LogDomains.EJB_LOGGER);
    
    private BaseContainer container;

    /**
     * This constructor is called from an EJBHome implementation's constructor.
     */
    protected EJBHomeImpl()
        throws RemoteException
    {
    }
    
    /**
     * Called from EJBHome implementation.
     */
    protected final Container getContainer() {
        return container;
    }
    
    
    /**
     * Called from BaseContainer only.
     */
    final void setContainer(BaseContainer c) {
        container = c;
    }

    /**
     * Get the EJBHome corresponding to an EJBHomeImpl.
     * These objects are one and the same when the home is generated,
     * but distinct in the case of dynamic proxies.  Therefore, code can't
     * assume it can cast an EJBHomeImpl to the EJBHome that
     * the client uses,  and vice-versa.  This is overridden in the 
     * InvocationHandler.
     */
    protected EJBHome getEJBHome() {
        return this;
    }
    
    /**
     * Create a new EJBObject and new EJB if necessary.
     * This is called from the generated "HelloEJBHomeImpl" create method.
     * Return the EJBObject for the bean.
     */
    public final EJBObjectImpl createEJBObjectImpl()
        throws RemoteException, CreateException
    {
        return container.createEJBObjectImpl();
    }

    public EJBObjectImpl createRemoteBusinessObjectImpl() 
        throws RemoteException, CreateException
    {
        return container.createRemoteBusinessObjectImpl();
    }
    
    
    /***************************************
***********************************
    The following are implementations of javax.ejb.EJBHome methods.
     **************************************************************************/
    
    /**
     * This is the implementation of the javax.ejb.EJBHome remove method.
     * @exception RemoveException on error during removal
     */
    public final void remove(Handle handle)
        throws RemoteException, RemoveException
    {
        container.authorizeRemoteMethod(BaseContainer.EJBHome_remove_Handle);
        
        EJBObject ejbo;
        try {
            ejbo = handle.getEJBObject();
        } catch ( RemoteException ex ) {
            _logger.log(Level.FINE, "Exception in method remove()", ex);
            NoSuchObjectException nsoe = 
                new NoSuchObjectException(ex.toString());
            nsoe.initCause(ex);
            throw nsoe;
        }
        ejbo.remove();
    }
    
    
    /**
     * This is the implementation of the javax.ejb.EJBHome remove method.
     * @exception RemoveException on error during removal
     */
    public final void remove(Object primaryKey)
        throws RemoteException, RemoveException
    {
        if ( !(container instanceof EntityContainer) ) {
            // Session beans dont have primary keys. EJB2.0 Section 6.6
            throw new RemoveException("Invalid remove operation.");
        }
        
        container.authorizeRemoteMethod(BaseContainer.EJBHome_remove_Pkey);
        
        Method method=null;
        try {
            method = EJBHome.class.getMethod("remove",
                        new Class[]{Object.class});
        } catch ( NoSuchMethodException e ) {
            _logger.log(Level.FINE, "Exception in method remove()", e);
        }
        
        ((EntityContainer)container).removeBean(primaryKey, method, false);
    }
    
    
    /**
     * This is the implementation of the javax.ejb.EJBHome method.
     */
    public final EJBMetaData getEJBMetaData()
        throws RemoteException
    {
        container.authorizeRemoteMethod(BaseContainer.EJBHome_getEJBMetaData);
        
        return container.getEJBMetaData();
    }
    
    /**
     * This is the implementation of the javax.ejb.EJBHome getHomeHandle
     * method.
     */
    public final HomeHandle getHomeHandle()
        throws RemoteException
    {
        container.authorizeRemoteMethod(BaseContainer.EJBHome_getHomeHandle);
        
        return new HomeHandleImpl(container.getEJBHomeStub());
    }
}
