/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers;


import javax.ejb.*;

import com.sun.ejb.*;

/**
 * Implementation common to EJBObjects and EJBLocalObjects.
 * It is extended by EJBObjectImpl and EJBLocalObjectImpl.
 *
 */
public abstract class EJBLocalRemoteObject
{
    protected static final boolean debug = false;

    transient protected BaseContainer container;
    transient protected Object primaryKey;
    transient private boolean removed=false;

    // Only used for stateful SessionBeans
    transient private SessionContextImpl context;
    
    //Used only for SFSBs. 
    private long sfsbClientVersion;
    

    final void setContainer(Container container)
    {
        this.container = (BaseContainer)container;
    }

    /**
     * Container needs to be accessed from generated code as well 
     * as from other classes in this package.  Rather than having one
     * public method, we have a protected one that is used from generated
     * code and a package-private one used within other container classes.
     * 
     */

    protected final Container getContainer()
    {
        return container;
    }

    final Container _getContainerInternal()
    {
        return container;
    }
    
    final void setRemoved(boolean r)
    {
        removed = r;
    }

    final boolean isRemoved()
    {
        return removed;
    }

    final void setKey(Object key)
    {
        primaryKey = key;
    }

    final Object getKey()
    {
        return primaryKey;
    }

    // Only used for stateful SessionBeans
    final SessionContextImpl getContext()
    {
        return context;
    }

    // Only used for stateful SessionBeans
    final void setContext(SessionContextImpl ctx)
    {
        context = ctx;
    }

    // Only used for stateful SessionBeans
    final void clearContext()
    {
        context = null;
    }
    
    //This is called when a local ref is serialized
    public long getSfsbClientVersion() {
        return this.sfsbClientVersion;
    }

    //This is called when the assocaited SFSB context is 
    //  checkpointed / passivated
    public void setSfsbClientVersion(long sfsbClientVersion) {
        this.sfsbClientVersion = sfsbClientVersion;
    }

} 
