package com.sun.ejb.containers;

import com.sun.enterprise.iiop.SFSBVersionConstants;
import com.sun.enterprise.iiop.SFSBServiceContextInfo;

public final class SFSBVersionManager
    implements SFSBVersionConstants {
  
    private static ThreadLocal<SFSBServiceContextInfo> scTLD
        = new ThreadLocal<SFSBServiceContextInfo>();

    public static long getRequestClientVersion() {
        SFSBServiceContextInfo ctx = scTLD.get();
        return (ctx != null) ? ctx.requestVersion : NO_VERSION; 
    }
    
    public static void setRequestClientVersion(long val) {
        SFSBServiceContextInfo ctx = scTLD.get();
        if (ctx == null) {
            ctx = new SFSBServiceContextInfo();
            scTLD.set(ctx);
        }

        ctx.requestVersion = val;
    }
    
    public static void clearRequestClientVersion() {
        SFSBServiceContextInfo ctx = scTLD.get();
        if (ctx != null) {
            ctx.requestVersion = NO_VERSION;
        }
    }
    
    public static long getResponseClientVersion() {
        SFSBServiceContextInfo ctx = scTLD.get();
        return (ctx != null) ? ctx.responseVersion : NO_VERSION;
    }

    public static void setResponseClientVersion(long val) {
        SFSBServiceContextInfo ctx = scTLD.get();
        if (ctx == null) {
            ctx = new SFSBServiceContextInfo();
            scTLD.set(ctx);
        }

        ctx.responseVersion = val;
    }
    
    public static void clearResponseClientVersion() {
        SFSBServiceContextInfo ctx = scTLD.get();
        if (ctx != null) {
            ctx.responseVersion = NO_VERSION;
        }
    }
    
    public static SFSBServiceContextInfo getServiceContext() {
        return scTLD.get();
    }
    
    public static void clearServiceContextInfo() {
        scTLD.set(null);
    }
    
}
