/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.containers.util;

import com.sun.corba.ee.spi.orbutil.threadpool.Work;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPoolManager;
import com.sun.corba.ee.spi.orbutil.threadpool.ThreadPool;
import com.sun.enterprise.util.S1ASThreadPoolManager;
import com.sun.enterprise.util.ORBManager;
import com.sun.enterprise.util.threadpool.Servicable;

/**
 * An adapter class that adapts Servicable interface to the new Work interface
 */
public class WorkAdapter
    implements Work
{
	private long enqueTime;
    private Servicable delegate;

    //This class delibarately doesn't define a no arg constructor
    //Once we identify all the code that use Servicable interface,
    //  we can make this class as abstract and all the container
    //  classes must extend this abstract class instead of 
    //  imoplementing the Servicable interface

    public WorkAdapter(Servicable delegate) {
        this.delegate = delegate;
    }

	public void setEnqueueTime(long timeInMillis) {
	    enqueTime = timeInMillis;
	}

	public long getEnqueueTime() {
	    return enqueTime;
	}
	
    public void doWork() {
        if (delegate != null) {
            delegate.service();
        }
    }
        
	public String getName() {
	    return "WorkAdapter";
    }

}
