/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.ejb.spi.distributed;

public interface DistributedEJBService {

    public int migrateTimers( String serverId );

    public String[] listTimers( String[] serverIds );

    /*
     * Since GMS is now dropped from 8.1, need a mechanism by which a canceltimer
     * initiated on another server instance would be affected on the owner server
     * instance. This would be done by reading the database before delivering the
     * ejbTimeout call to ensure that the timer is still valid. Since this would 
     * lead to potential performance degradation also need to provide some user
     * interaction to control this behavior.
     *
     * For SE/EE the default value if system property is not specified would be 
     * "true" (i.e. always read from DB before delivering a ejbTimeout for a timer)
     *
    */
    public void setPerformDBReadBeforeTimeout( boolean defaultDBReadValue );

    public DistributedReadOnlyBeanService getDistributedReadOnlyBeanService();
    
} //DistributedEJBService.java 
