/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise;

import javax.naming.*;
import java.util.Hashtable;
import com.sun.enterprise.deployment.*;

/**
 * The NamingManager provides an interface for various components to
 * use naming functionality. It provides methods for binding and unbinding
 * environment properties, resource and ejb references. It also provides
 * an API to get the current component id.
 * @author Vivek Nagar
 */
public interface NamingManager {

    /**
     * Get the initial context.
     */

    public Context getInitialContext();

    /**
     * Publish a name in the naming service.
     * @param the Object that needs to be bound.
     * @param the Name that the object is bound as.
     * @param if operation is a bind or a rebind.
     * @exception Exception
     */

     public void publishObject(String name, Object obj, boolean rebind) 
	throws NamingException;

    /**
     * Publish a name in the naming service.
     * @param the Object that needs to be bound.
     * @param the Name that the object is bound as.
     * @param if operation is a bind or a rebind.
     * @exception Exception
     */

     public void publishObject(Name name, Object obj, boolean rebind) 
	throws NamingException;

    /**
     * Remove an object from the naming service.
     * @param the Name that the object is bound as.
     * @exception Exception
     */
     public void unpublishObject(String name) 
    throws NamingException;

    /**
     * Remove an object from the naming service.
     * @param the Name that the object is bound as.
     * @exception Exception
     */
     public void unpublishObject(Name name) 
    throws NamingException;

    /**
     * Enumerates over the list of env props, resource and ejb references
     * and binds them in the java:comp namespace.
     */
     public String bindObjects(JndiNameEnvironment env) throws NamingException;

    /**
     * Enumerates over the list of env props, resource and ejb references
     * and unbinds them from the java:comp namespace.
     */
     public void unbindObjects(JndiNameEnvironment env) throws NamingException;

    /**
     * Recreate a context for java:comp/env or one of its sub-contexts given
     * the context name.  
     */
    public Context restoreJavaCompEnvContext(String contextName) throws NamingException;
}
