/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.alert;

import javax.management.NotificationListener;
import javax.management.NotificationFilter;

import java.util.List;
import java.util.ArrayList;
import java.util.StringTokenizer;

/**
 * Class AlertSubscriptionInfo  contains a list of ObjectNames (only the name
 * elements of Monitors and MBeans whose notifications it's interested in) and
 * the NotificationListener and the NotificationFilter if any.
 *
 * @AUTHOR: Hemanth Puttaswamy 
 */
public class AlertSubscriptionInfo {
    // monitorNames (subscribe-listener-with attribute) from domain.xml  
    private List monitorNames;

    // NotificationListner to subscribe 
    private NotificationListener listener;

    // NotificationFilter to subscribe 
    private NotificationFilter filter;
 
    /**
     * A comma separated list of monitor names will be passed as is read from
     * domain.xml's alert-service, subscribe-listener-with attribute.
     */
    public AlertSubscriptionInfo(String subscribeListenersWith,
        NotificationListener listener, NotificationFilter filter )
    {
        // No need to check for null as it is already done by domain.xml's
        // validation.
        StringTokenizer tokenizer = 
            new StringTokenizer( subscribeListenersWith, "," );
        ArrayList list = new ArrayList( );
        while( tokenizer.hasMoreTokens( ) ) {
            String monitorName = tokenizer.nextToken( );
            list.add( monitorName.trim() );
        }
        monitorNames = list;
        this.listener = listener;
        this.filter = filter;
    }
        
    List getMonitorNames( ) {
        return monitorNames;
    }

    NotificationListener getNotificationListener( ) {
        return listener;
    }

    NotificationFilter getNotificationFilter( ) {
        return filter;
    }
}
