/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.event;

import com.sun.enterprise.deployment.pluggable.DeploymentFactory;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.pluggable.PluggableFeatureFactory;

/**
 * Managed the synchronization functionalities needed 
 * @author deployment dev team
 */
public abstract class DeployEventListenerHelper {

    /**
     * We should revisit this to make sure this will work in multi-threaded environment, 
     * i.e. concurrent deployment.
     */
    public static DeployEventListenerHelper getDeployEventListenerHelper() {

        PluggableFeatureFactory featureFactory =
            ApplicationServer.getServerContext().getPluggableFeatureFactory();
        DeploymentFactory dFactory = featureFactory.getDeploymentFactory();
        DeployEventListenerHelper helper = 
                dFactory.createDeployEventListenerHelper();
        return helper;
    }

    /**
     * Synchronize the application
     */
    public abstract void synchronize(BaseDeployEvent event) throws AdminEventListenerException;
}
