/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;

/**
 * Monitoring Event. A monitoring event should trigger start, stop or
 * collection of monitoring data for specified component.
 */
public class MonitoringEvent extends AdminEvent {

    /**
     * Constant denoting action of monitoring start
     */
    public static final String START_MONITORING = "start_monitoring";

    /**
     * Constant denoting action of monitoring stop
     */
    public static final String STOP_MONITORING = "stop_monitoring";

    /**
     * Constant denoting action of get monitoring data (collection of data)
     */
    public static final String GET_MONITOR_DATA = "get_monitoring";

    /**
     * Constant denoting action of list monitorable components
     */
    public static final String LIST_MONITORABLE = "list_monitorable";

    /**
     * Constant denoting action of set (for TxnMgr admin currently)
     */
    public static final String SET_MONITOR_DATA = "set_monitoring";

    /**
     * Event type
     */
    static final String eventType = MonitoringEvent.class.getName();

    private String componentName;
    private String actionCode;
    private Object command;

    /**
     * Create a new MonitoringEvent.
     * @param instance name of the server instance to which this event applies
     * @param component name of the server component to which this event applies
     * @param action monitoring action, one of MonitoringEvent.START_MONITORING,
     *        MonitoringEvent.STOP_MONITORING, MonitoringEvent.GET_MONITOR_DATA,
     *        MonitoringEvent.LIST_MONITORABLE
     */
    public MonitoringEvent(String instance, String component, String action) {
        this(instance, component, action, null);
    }

    /**
     * Create a new MonitoringEvent.
     * @param instance name of the server instance to which this event applies
     * @param component name of the server component to which this event applies
     * @param action monitoring action, one of MonitoringEvent.START_MONITORING,
     *        MonitoringEvent.STOP_MONITORING, MonitoringEvent.GET_MONITOR_DATA,
     *        MonitoringEvent.LIST_MONITORABLE
     * @param command a monitoring command. Command is extra information that
     *        is used in monitoring event listeners. This is typically an
     *        instance of com.sun.enterprise.admin.monitor.MonitorCommand (or its
     *        sub-class) and may be null.
     */
    public MonitoringEvent(String instance, String component, String action,
            Object command) {
        super(eventType, instance);
        componentName = component;
        actionCode = action;
        this.command = command;
    }

    /**
     * Get name of component to which this event applies.
     */
    public String getComponentName() {
        return componentName;
    }

    /**
     * Get event action code - one of MonitoringEvent.START_MONITORING,
     * MonitoringEvent.STOP_MONITORING, MonitoringEvent.GET_MONITOR_DATA,
     * MonitoringEvent.LIST_MONITORABLE
     */
    public String getActionCode() {
        return actionCode;
    }

    /**
     * Get monitoring command information. This is used to access an
     * instance of com.sun.enterprise.admin.monitor.MonitorCommand (or its sub
     * classes) from the event. This may be null.
     * @return Monitoring command
     */
    public Object getCommand() {
        return command;
    }

    /**
     * Get a string representation.
     */
    public String toString() {
        return "MonitoringEvent -- " + componentName + " -- " + actionCode;
    }
}
