/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */
package com.sun.enterprise.admin.event;

/**
 * This is the listener interface that should be implemented to handle all
 * events related to application server resource deployment (deployed,
 * undeployed, redeployed, enabled and disabled).
 */
public interface ResourceDeployEventListener extends AdminEventListener {

    /**
     * Invoked when an application server resource is deployed.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void resourceDeployed(ResourceDeployEvent event)
             throws AdminEventListenerException;

    /**
     * Invoked when an application server resource is undeployed.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void resourceUndeployed(ResourceDeployEvent event)
             throws AdminEventListenerException;

    /**
     * Invoked when an application server resource is redeployed.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void resourceRedeployed(ResourceDeployEvent event)
             throws AdminEventListenerException;

    /**
     * Invoked when an application server resource is enabled.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void resourceEnabled(ResourceDeployEvent event)
             throws AdminEventListenerException;

    /**
     * Invoked when an application server resource is disabled.
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void resourceDisabled(ResourceDeployEvent event)
             throws AdminEventListenerException;
    
    /**
     * Invoked when a resource reference is created from a 
     * server instance (or cluster) to a particular resource.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void resourceReferenceAdded(ResourceDeployEvent event)
            throws AdminEventListenerException;

    /**
     * Invoked when a resource reference is removed from a 
     * server instance (or cluster) to a particular resource.
     *
     * @throws AdminEventListenerException when the listener is unable to
     *         process the event.
     */
    public void resourceReferenceRemoved(ResourceDeployEvent event)
            throws AdminEventListenerException;

}
