/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.enterprise.server.ServerContext;


public class DeclarativeLifecycleEventService implements ServerLifecycle {
    
    private  static volatile LifeCycleImpl lifecycleImpl = null;
    // singleton to be constructed by LifeCycle Module
    public DeclarativeLifecycleEventService() {
    }
    
    // To give the call backs to the listener
    static synchronized void setLifeCycleImpl(LifeCycleImpl impl) {
        lifecycleImpl = impl;
    }
    
    /**
     * Notification sequence number within the source object.
     */
    private long sequenceNumber = 0;
    
    public void onInitialization(ServerContext sc)
    throws ServerLifecycleException {
        // nothing to do
    }
    
    public void onStartup(ServerContext sc)
    throws ServerLifecycleException {
    }
    
    
    public void onReady(ServerContext sc)
    throws ServerLifecycleException {
        if (lifecycleImpl != null)
            lifecycleImpl.onReady(sc);
        
    }
    
    public void onShutdown()
    throws ServerLifecycleException {
        if (lifecycleImpl != null)
            lifecycleImpl.onShutdown();
    }
    
    public void onTermination()
    throws ServerLifecycleException {
        if (lifecycleImpl != null)
            lifecycleImpl.onTermination();
        
    }
}
