/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.selfmanagement.event;
import java.util.Map;
import java.util.HashMap;
import javax.management.NotificationFilter;
import javax.management.Notification;
import static com.sun.appserv.management.event.TraceEventHelper.*;

public class TraceEventNotificationFilter implements NotificationFilter {
    public TraceEventNotificationFilter(String type, String ipAddress,
                             String callerPrincipal, String componentName) {
        this.type = type;
        this.ipAddress = ipAddress;
        this.callerPrincipal = callerPrincipal;
        this.componentName = componentName;
    }
    
    public boolean isNotificationEnabled(Notification notification) {
        if ("*".equals(type) || type.equals(notification.getType()) ) {
            Map map = (HashMap)notification.getUserData();
            if (map != null) {
               if (ipAddress != null && !(ipAddress.equals("*")) && 
                  !(ipAddress.equals(map.get(CALLER_IPADDRESS)))) {
                   return false;
               }
               if (callerPrincipal != null && !(callerPrincipal.equals("*")) && 
                  !(callerPrincipal.equals(map.get(CALLER_PRINCIPAL)))) { 
                   return false;
               }
               if (componentName != null && !(componentName.equals("*")) && 
                  !(componentName.equals(map.get(COMPONENT_NAME)))) { 
                   return false;
               }
               return true;
            } else {
                return false;
            }
            
        }
        else
            return false;
    }
    private String type;
    private String ipAddress;
    private String callerPrincipal;
    private String componentName;
}
