/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core;

import java.util.*;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.appserv.server.ServerLifecycle;
import com.sun.appserv.server.ServerLifecycleImpl;
import com.sun.enterprise.admin.server.core.channel.AdminChannel;

import com.sun.enterprise.server.ServerContext;

import java.util.logging.*;
import com.sun.logging.LogDomains;


/**
 * Lifecycle that manages the RMI server that communicates with clients.
 */
public class AdminChannelLifecycle extends ServerLifecycleImpl {

    private static final int NOTINITIALIZED = 0;
    private static final int INITIALIZED = 1;
    private static final int READY       = 2;
    private static final int SHUTDOWN    = 3;

    private static int status = NOTINITIALIZED;

    /**
     * Server is Inililize the AdminChannel.
     *
     * @exception ServerLifecycleException if this subsystem detects a fatal
     *  error that prevents this subsystem from being used
     */
    public void onInitialization(ServerContext context)
        throws ServerLifecycleException {
        if (status < INITIALIZED) {
            status = INITIALIZED;
            AdminChannel.createRMIChannel();
            AdminChannel.createSharedSecret();
        }
    }

    /**
     * Server is ready.
     *
     * @exception ServerLifecycleException if this subsystem detects a fatal
     *  error that prevents this subsystem from being used
     */
    public void onReady(ServerContext context)
        throws ServerLifecycleException {
        if (status < READY) {
            status = READY;
            AdminChannel.setRMIChannelReady();
        }
    }

    /**
     * Server is shutting down applications
     *
     * @exception ServerLifecycleException if this subsystem detects a fatal
     *  error that prevents this subsystem from being used
     */
    public void onShutdown()
        throws ServerLifecycleException {
        if (status < SHUTDOWN) {
            status = SHUTDOWN;
            AdminChannel.setRMIChannelStopping();
            AdminChannel.destroyRMIChannel();
        }
    }

    /**
     * Server startup has failed. This could be due to a port conflict exception.
     * In case of port conflict exception, port will be >0. Set the RMI channel server 
     * status to kInstanceFailed.
     * @param port portnumber 
     */
    public void onAbort(int port) 
        throws ServerLifecycleException {
        AdminChannel.setRMIChannelAborting(port);
    }

}

