/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core;

//Tomcat
import com.sun.enterprise.instance.InstanceEnvironment;

/**
    This class holds the result of Manual change check for 1 instance.
    It is a simple bean with getter and setter of all files that are used for checking
    Note: the list of files should be in sync with InstanceEnvironment.java
	@author  Sridatta
	@version 1.1
*/

public final class ManualChangeStatus {
    private boolean objectFileChanged = false;
    private boolean initFileChanged = false;
    private boolean realmsKeyFileChanged = false;
    private boolean serverXmlFileChanged = false;
    private boolean aclFileChanged = false;
    private boolean mimeFileChanged = false;
    private boolean virtualServerConfFilesChanged = false;
    
    public boolean isObjectFileChanged() {
        return objectFileChanged;
    }
    
    public boolean isInitFileChanged() {
        return initFileChanged;
    }
        
    public boolean isRealmsKeyFileChanged() {
        return realmsKeyFileChanged;
    }
            
    public boolean isServerXmlFileChanged() {
        return serverXmlFileChanged;
    }
                
    public boolean isAclFileChanged() {
        return aclFileChanged;
    }
    public boolean isMimeFileChanged() {
        return mimeFileChanged;
    }

    public boolean isVirtualServerConfFilesChanged() {
        return virtualServerConfFilesChanged;
    }

    public void setObjectFileChanged(boolean value) {
        objectFileChanged = value;
    }
    
    public void setInitFileChanged(boolean value) {
        initFileChanged = value;
    }
        
    public void setRealmsKeyFileChanged(boolean value) {
        realmsKeyFileChanged = value;
    }
            
    public void setServerXmlFileChanged(boolean value) {
        serverXmlFileChanged = value;
    }
                
    public void setAclFileChanged(boolean value) {
        aclFileChanged = value;
    }
    public void setMimeFileChanged(boolean value) {
        mimeFileChanged = value;
    }
    
    public void setVirtualServerConfFilesChanged(boolean value) {
        virtualServerConfFilesChanged = value;
    }

    public boolean isChanged() {
        /* TOMCAT_BEGIN Ramakanth */
        return (isServerXmlFileChanged() || 
            isRealmsKeyFileChanged());
        /* TOMCAT_END Ramakanth */
    }

    public String toString() {
        /* TOMCAT_BEGIN Ramakanth */
        return "ManualChangeStatus:\n" + 
            "\tserverXmlFileChanged = " + serverXmlFileChanged + "\n" + 
            "\trealmsKeyFileChanged = " + realmsKeyFileChanged + "\n";
        /* TOMCAT_END Ramakanth */
    }
    
}
