/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * ServerAndDAS_TlsClientEnvSetter.java
 */

package com.sun.enterprise.admin.server.core.jmx.ssl;
import com.sun.enterprise.admin.server.core.InMemoryX509TrustManager;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.util.SystemPropertyConstants;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Ssl;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.ServerHelper;

import java.io.File;
import javax.net.ssl.TrustManager;


/** This class is meant specifically for the setup of client side environment 
 * when the server (DAS and instances come up)
 * @author  Nandini.Ektare@sun.com
 * @since Sun Java System Application Server 8.2ee
 */
public class ServerClientEnvSetter extends AsTlsClientEnvSetter {
 
    protected String mCertNickName;
    
    public ServerClientEnvSetter(String certNickname) {
        super();
        mCertNickName = certNickname;
    }

    protected TrustManager[] getTrustManagers() {
        return new TrustManager[] { 
            new InMemoryX509TrustManager(mCertNickName) };
    }

}