/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.config;

//JMX imports
import javax.management.*;

//Config imports
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;
import com.sun.enterprise.config.serverbeans.ServerXPathHelper;


//Admin imports
import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;

/**
    This Config MBean represents a a JNDI-resource.
    It extends ConfigMBeanBase class which provides get/set attribute(s) and getMBeanInfo services according to text descriptions.
    ObjectName of this MBean is:
        ias: ctype=jndi, instance-name=<instance-name>
*/
public class ManagedJNDIResource extends ConfigMBeanBase implements ConfigAttributeName.ExternalJndiResource
{
    /** 
     * MAPLIST array defines mapping between "external" name and its location in XML relatively base node
     */
    private static final String[][] MAPLIST  =
    {
        {kJndiName       , ATTRIBUTE + ServerTags.JNDI_NAME},
        {kJndiLookupName , ATTRIBUTE + ServerTags.JNDI_LOOKUP_NAME},
        {kResType        , ATTRIBUTE + ServerTags.RES_TYPE},
        {kFactoryClass   , ATTRIBUTE + ServerTags.FACTORY_CLASS},
//MS1        {kEnabled        , ATTRIBUTE + ServerTags.ENABLED},
        {kDescription    , ATTRIBUTE + PSEUDO_ATTR_DESCRIPTION},
    };
    /** 
     * ATTRIBUTES array specifies attributes descriptions in format defined for MBeanEasyConfig
     */
    private static final String[]   ATTRIBUTES  =
    {
        kJndiName       + ", String,   R" ,
        kJndiLookupName + ", String,   RW" ,
        kResType        + ", String,   RW" ,
        kFactoryClass   + ", String,   RW" ,
//MS1        kEnabled        + ", boolean,  RW" ,
        kDescription    + ", String,   RW" ,
    };
    /** 
     * OPERATIONS array specifies op;erations descriptions in format defined for MBeanEasyConfig
     */
    private static final String[]   OPERATIONS  = null;
    
    
    /**
        Default constructor sets MBean description tables
    */
    public ManagedJNDIResource() throws MBeanConfigException
    {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    /**
     * Constructs Config MBean for JNDI Resource.
     * @param instanceName The server instance name.
     * @param jndiName     JNDI name associated with resource
     */
    public ManagedJNDIResource(String instanceName, String jndiName) throws ConfigException,MBeanConfigException
    {
        this(); //set description tables
        initialize(ObjectNames.kJndiResourceType, new String[]{instanceName, jndiName});
    }
}
