/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.server.core.mbean.config;

//JMX imports
import javax.management.*;

//Config imports
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ServerTags;

//Admin imports
import com.sun.enterprise.admin.server.core.mbean.meta.MBeanEasyConfig;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.admin.common.constant.ConfigAttributeName;
import com.sun.enterprise.admin.common.ObjectNames;

/**
    Represents a Persistence Manager Factory resource.

    ObjectName of this MBean is:
        ias: component=persistence-manager-factory-resource, instance-name=<instance-name>
*/
public class ManagedPMFactoryResource extends ConfigMBeanBase implements ConfigAttributeName.PMFactoryResource
{
    private static final String[][] MAPLIST  =  {
        {kJndiName,               ATTRIBUTE + ServerTags.JNDI_NAME},
        {kFactoryClass,           ATTRIBUTE + ServerTags.FACTORY_CLASS},
        {kJdbcResourceJndiName,   ATTRIBUTE + ServerTags.JDBC_RESOURCE_JNDI_NAME},
//ms1        {kEnabled,                ATTRIBUTE + ServerTags.ENABLED},
        {kDescription,            ATTRIBUTE + PSEUDO_ATTR_DESCRIPTION},
    };

    private static final String[]   ATTRIBUTES  = 
    {
        kJndiName                 + ", String,  R" ,
        kFactoryClass             + ", String,  RW" ,
        kJdbcResourceJndiName     + ", String,  RW",
//ms1        kEnabled                  + ", boolean,  RW" ,
        kDescription              + ", String,   RW" ,
    };

    private static final String[]   OPERATIONS  = null;

    /**
        Default constructor sets MBean description tables
    */
    public ManagedPMFactoryResource() throws MBeanConfigException
    {
        this.setDescriptions(MAPLIST, ATTRIBUTES, OPERATIONS);
    }

    public ManagedPMFactoryResource(String instanceName, String jndiName) 
        throws MBeanConfigException
    {
        this(); //set description tables
        initialize(ObjectNames.kPersistenceManagerFactoryResourceType, new String[]{instanceName, jndiName});
    }
}
