/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */

package com.sun.enterprise.admin.verifier.tests;

/*  Test case to check the validity of Applications fields
 *  Author : srini@sun.com
 */


// 8.0 XML Verifier
//import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.ConfigContextEvent;

import com.sun.enterprise.admin.verifier.*;

// Logging
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;


public class ApplicationsTest extends ServerXmlTest implements ServerCheck {
    
     // Logging
    static Logger _logger = LogDomains.getLogger(LogDomains.APPVERIFY_LOGGER);
    
    public ApplicationsTest() {
    }
 
    // check method invoked by the command line verifier
    public Result check(ConfigContext context) {
            Result result;
            result = super.getInitializedResult();
            // 8.0 XML Verifier
            /*try {
                Server server = (Server)context.getRootConfigBean();
                Applications app = server.getApplications();
                String pollInterval = app.getDynamicReloadPollIntervalInSeconds();
                try {
                    if(Integer.parseInt(pollInterval) < 0) 
                        //result.failed("Reload Poll Interval cannot be negative number");
                        result.failed(smh.getLocalString(getClass().getName() + ".reloadNegative","Reload Poll Interval cannot be negative number"));
                    else
                        result.passed("Passed *** ");
                } catch(NumberFormatException e) {
                    //result.failed("Reload Poll Interval : invalid number");
                    result.failed(smh.getLocalString(getClass().getName()+".reloadInvalid","Reload Poll Interval : invalid number"));
                }
            }
            catch(Exception ex) {
                // Logging
                _logger.log(Level.FINE, "serverxmlverifier.exception", ex);
                result.failed("Exception : " + ex.getMessage());
            }*/
            return result;
    }
    
    // check method called from the admin GUI and iasadmin
    public Result check(ConfigContextEvent ccce) {
                Object value = ccce.getObject();
                ConfigContext context = ccce.getConfigContext();
                Result result = new Result();
                result.passed("Passed ** ");
                String beanName = ccce.getBeanName();
                if(beanName!=null) {
                    String name = ccce.getName();
                    if(name != null && value != null)
                        result = validateAttribute(name, (String)value);
                    return result;
                }
                
                return result;
    }    
    
    public Result validateAttribute(String name, String value) {
            boolean failed = false;
            Result result = new Result();
            result.passed("Passed **");
            if(name.equals(ServerTags.DYNAMIC_RELOAD_POLL_INTERVAL_IN_SECONDS)) {
                try {
                    if(Integer.parseInt(value) < 0) {
                        //result.failed("Reload poll Interval cannot be negative number");
                        result.failed(smh.getLocalString(getClass().getName()+ ".reloadNegative","Reload Poll Interval cannot be negative number"));
                        failed = true;
                    }
                    else
                        result.passed("passed ***");
                } catch(NumberFormatException e) {
                    //result.failed("Reload Poll Interval : invalid number");
                    result.failed(smh.getLocalString(getClass().getName()+".reloadInvalid","Reload Poll Interval : invalid number"));
                    failed = true;
                } 
            }
            if(failed)
                result.setStatus(Result.FAILED);
            return result;
    }
    
}
