/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/**
 * PROPRIETARY/CONFIDENTIAL.  Use of this product is subject to license terms.
 *
 * Copyright 2001-2002 by iPlanet/Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 */

package com.sun.enterprise.admin.verifier.tests;

import java.net.*;

/* Test Case which validates the JmsService Fields
 * Author : srini@sun.com
 **/

// 8.0 XML Verifier
//import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import  com.sun.enterprise.config.serverbeans.*;

import com.sun.enterprise.admin.verifier.*;
// Logging
import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;


public class JmsServiceTest extends ServerXmlTest implements ServerCheck {
    // Logging
    static Logger _logger = LogDomains.getLogger(LogDomains.APPVERIFY_LOGGER);
    
    public JmsServiceTest() {
    }
 
    // check method called by command line verifier
    public Result check(ConfigContext context)
    {
        Result result;
        result = super.getInitializedResult();
        //<addition author="irfan@sun.com" [bug/RFE]-id="" >
        // 8.0 XML Verifier
        /*try {
            Server server = (Server)context.getRootConfigBean();
            JmsService jms = server.getJmsService();
            String httpPort = jms.getPort();
            try {
                if(StaticTest.isPortValid(Integer.parseInt(httpPort))) 
                       result.passed("Valid Port");
                else
                       result.failed("Invalid JMSService Port - " + httpPort);
            }
            catch(NumberFormatException e) {
                result.failed("Invalid JMSService Port Number - " + httpPort);
            }
            // Bug : 4713369
            try {
                String timeout = jms.getInitTimeoutInSeconds();
                if(Integer.parseInt(timeout) < 0)
                    result.failed(smh.getLocalString(getClass().getName()+".initTimeoutNegative","Init Timeout cannot be negative number"));
                else
                    result.passed("** Passed ** ");
            } catch(NumberFormatException e) {
                result.failed(smh.getLocalString(getClass().getName()+".initTimeoutInvalid","Init Timeout : invalid number"));
            }
        }
        catch(Exception ex) {
            //<addition author="irfan@sun.com" [bug/rfe]-id="logging" >
            /*ex.printStackTrace();
            result.failed("Exception : " + ex.getMessage());
            // Logging
            _logger.log(Level.FINE, "serverxmlverifier.exception", ex);
            result.failed("Exception : " + ex.getMessage());
            //</addition>
        }*/
        //</addition>
        return result;
    }
    
    // check method called by iasadmin and admin GUI
    public Result check(ConfigContextEvent ccce) {
        Result result = new Result();
        Object value = ccce.getObject();
        String beanName = ccce.getBeanName();
        if(beanName!=null) {
               String name = ccce.getName();
               return testSave(name, (String) value);
        }
        
        //<addition author="irfan@sun.com" [bug/RFE]-id="" >
        // 8.0 XML Verifier
        //JmsService jms = (JmsService) value;                
        JmsHost jms = (JmsHost) value;
        //</addition>
        String httpPort = jms.getPort();
        try {
            if(StaticTest.isPortValid(Integer.parseInt(httpPort))) 
                   result.passed("Valid Port");
            else
                   result.failed("Invalid JMSService Port : " + httpPort);
        }
        catch(NumberFormatException e) {
            result.failed("Invalid JMSService Port Number : " + httpPort);
        }
        return result;
    }
    
    public Result testSave(String name, String value) {
        Result result = new Result();
        result.passed("Passed");
        if(name.equals(ServerTags.PORT)) {
            try {
                if(StaticTest.isPortValid(Integer.parseInt(value)))
                    result.passed("Valid Port");
                else
                    result.failed("Invalid Port");
            } catch(NumberFormatException e) {
                result.failed("Bad Number");
            }
        }
        // check if init timeout is valid
        // Bug : 4713369
        if(name.equals(ServerTags.INIT_TIMEOUT_IN_SECONDS)) {
            try {
                if(Integer.parseInt(value) < 0)
                    result.failed(smh.getLocalString(getClass().getName()+".initTimeoutNegative","Init Timeout cannot be negative number"));
                else
                    result.passed("Passed **");
            } catch (NumberFormatException e) {
                 result.failed(smh.getLocalString(getClass().getName()+".initTimeoutInvalid","Init Timeout : invalid number"));
            }
        }
        return result;
    }
}
