/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors;
import java.util.logging.*;
import javax.resource.spi.ResourceAdapter;
import com.sun.logging.LogDomains;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.connectors.system.*;
import com.sun.enterprise.connectors.util.JmsRaUtil;


/**
 * Factory creating Active Resource adapters.
 *
 * @author  Binod P.G
 */
public class ActiveRAFactory {
    static Logger _logger = LogDomains.getLogger(LogDomains.RSR_LOGGER);     

    /**
     * Creates an active resource adapter.
     *
     * @param cd Deployment descriptor object for connectors.
     * @param moduleName Module name of the resource adapter.
     * @param loader Class Loader,
     * @param writeSunDescriptor Boolean indicating whether sundescriptor
     *        need to be written or not.
     * @return An instance of <code> ActiveResourceAdapter </code> object.
     * @throws ConnectorRuntimeException.
     */
    public static ActiveResourceAdapter createActiveResourceAdapter(
        ConnectorDescriptor cd, String moduleName, ClassLoader loader) 
        throws ConnectorRuntimeException{

        ActiveResourceAdapter activeResourceAdapter = null;
        int environment = ConnectorRuntime.getRuntime().getEnviron();
        ResourceAdapter ra = null;
        String raClass = cd.getResourceAdapterClass();

        try {

            // If raClass is available, load it...
            if (raClass != null && !raClass.equals("")) {
                if(environment == ConnectorRuntime.SERVER) {
                    ra = (ResourceAdapter) 
                          loader.loadClass(raClass).newInstance();
                } else {
                    ra = (ResourceAdapter)Class.forName(raClass).newInstance();
                }

            }

            /*
             * If any special handling is required for the system resource 
             * adapter, then ActiveResourceAdapter implementation for that
             * RA should implement additional functionality by extending
             * ActiveInboundResourceAdapter or ActiveOutboundResourceAdapter.
             *
             * For example ActiveJmsResourceAdapter extends 
             * ActiveInboundResourceAdapter.
             */
            if (moduleName.equals(ConnectorConstants.DEFAULT_JMS_ADAPTER)) {
                // Upgrade jms resource adapter, if necessary before starting 
                // the RA.
		try {
                	JmsRaUtil raUtil = new JmsRaUtil();
                	raUtil.upgradeIfNecessary();
		}
		catch (Throwable t) {
            	_logger.log(Level.FINE,"Cannot upgrade jmsra"+ t.getMessage());
		}

                activeResourceAdapter = new ActiveJmsResourceAdapter(
                                                 ra,cd,moduleName,loader);
            } else if (raClass.equals(""))  {
                activeResourceAdapter = new ActiveOutboundResourceAdapter(
                                 cd,moduleName,loader);
            } else {
                activeResourceAdapter = new ActiveInboundResourceAdapter(
                                                 ra,cd,moduleName,loader);
            }
	     
        } catch (ClassNotFoundException Ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(
                                             "Error in creating active RAR");
            cre.initCause(Ex);
            _logger.log(Level.SEVERE,"rardeployment.class_not_found",raClass);
            _logger.log(Level.SEVERE,"",cre);
            throw cre; 
        } catch (InstantiationException Ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(
                                             "Error in creating active RAR");
            cre.initCause(Ex);
            _logger.log(Level.SEVERE,"rardeployment.class_instantiation_error",
                                    raClass);
            _logger.log(Level.SEVERE,"",cre);
            throw cre; 
        } catch (IllegalAccessException Ex) {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(
                                             "Error in creating active RAR");
            cre.initCause(Ex);
            _logger.log(Level.SEVERE,"rardeployment.illegalaccess_error",
                         raClass);
            _logger.log(Level.SEVERE,"",cre);
            throw cre; 
        } 

        return activeResourceAdapter;

    }


}
