/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors;

import com.sun.enterprise.connectors.util.ResourcesUtil;
import java.util.*;
import java.util.logging.*;
import javax.naming.*;
import com.sun.enterprise.server.*;

/**
 * AdminObject administration service. It performs the functionality of 
 * creating and deleting the Admin Objects
 * @author    Binod P.G and Srikanth P 
 */


public class ConnectorAdminObjectAdminServiceImpl extends 
               ConnectorServiceImpl implements ConnectorAdminService {


    public ConnectorAdminObjectAdminServiceImpl() {
        super();
    }
     
    public void addAdminObject (
            String appName,
            String connectorName,
            String jndiName,
            String adminObjectType,
            Properties props)
            throws ConnectorRuntimeException 
    {
        ActiveResourceAdapter ar = 
                    _registry.getActiveResourceAdapter(connectorName);
        if(ar == null) {
            ifSystemRarLoad(connectorName);
            ar = _registry.getActiveResourceAdapter(connectorName);
        }
        if (ar instanceof ActiveInboundResourceAdapter)  {
            ActiveInboundResourceAdapter air = 
                            (ActiveInboundResourceAdapter) ar;
            air.addAdminObject(appName,connectorName,jndiName,
                            adminObjectType, props);
        } else {
            ConnectorRuntimeException cre = new ConnectorRuntimeException(
                            "This adapter is not 1.5 compliant");
            _logger.log(Level.SEVERE, 
                            "rardeployment.non_1.5_compliant_rar",jndiName);
            throw cre;
        }
    }

    public void deleteAdminObject(String jndiName) 
                           throws ConnectorRuntimeException 
    {

        try {
            InitialContext ic = new InitialContext();
            ic.unbind(jndiName);
        }
        catch(NamingException ne) {
            ResourcesUtil resutil = ResourcesUtil.createInstance();
            if(resutil.adminObjectBelongsToSystemRar(jndiName)) {
                return;
            }
            if(ne instanceof NameNotFoundException){
                _logger.log(Level.FINE,
                  "rardeployment.admin_object_delete_failure",jndiName);
                _logger.log(Level.FINE,"", ne);
                return;
            }
            ConnectorRuntimeException cre = new ConnectorRuntimeException(
                           "Failed to delete admin object from jndi");
            cre.initCause(ne);
            _logger.log(Level.SEVERE,
                  "rardeployment.admin_object_delete_failure",jndiName);
            _logger.log(Level.SEVERE,"", cre);
            throw cre; 
        }
    }
}
