/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.connectors.inflow;

import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.AbstractConnectorAllocator;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.XAResourceWrapper;
import com.sun.logging.LogDomains;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;

public final class BasicResourceAllocator extends AbstractConnectorAllocator {

    private static final Logger logger = 
    LogDomains.getLogger(LogDomains.RSR_LOGGER);

    private static final String JMS_RESOURCE_FACTORY = "JMS";

    public BasicResourceAllocator () {}

    public ResourceHandle createResource()
        throws PoolingException {
        throw new UnsupportedOperationException();
    }

    public ResourceHandle createResource(XAResource xaResource)
         throws PoolingException {

        ResourceHandle resourceHandle = null;
        ResourceSpec spec =
                new ResourceSpec(JMS_RESOURCE_FACTORY,
                                 ResourceSpec.JMS);
        
        if (xaResource != null) {
            
            logger.logp(Level.FINEST, 
                    "BasicResourceAllocator", "createResource",
                    "NOT NULL", xaResource);
            
            try {
                resourceHandle = new ResourceHandle(
                        null,  //no object present
		        spec,
                        this, null);
                
                if (logger.isLoggable(Level.FINEST)) {
                    xaResource = new XAResourceWrapper(xaResource);
                }
                    
                resourceHandle.fillInResourceObjects(null, xaResource);

            } catch (Exception e) {
                throw (PoolingException) (new PoolingException()).initCause(e);
            }
        } else {
            logger.logp(Level.FINEST, 
                    "BasicResourceAllocator", "createResource",
                    "NULL", xaResource);
        }

        return resourceHandle;
    }
    

    public void closeUserConnection(ResourceHandle resourceHandle) 
        throws PoolingException {
        throw new UnsupportedOperationException();
    }


    public boolean matchConnection(ResourceHandle resourceHandle) {
        return false;
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle resourceHandle) 
        throws PoolingException {
        throw new UnsupportedOperationException();
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public boolean isConnectionValid( ResourceHandle resource ) {
        throw new UnsupportedOperationException();
    }

}
