/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.connectors.inflow;

import javax.resource.spi.ActivationSpec;
import javax.resource.spi.endpoint.MessageEndpointFactory;

/**
 * An instance of this class keeps <code> ActivationSpec <code>
 * and <code>MessageEndPointFactory</code> related to a endpoint
 * activation.
 *
 * @author	Qingqing Ouyang
 */
public final class MessageEndpointFactoryInfo
{
    //@@@ should we include name of the MDB here?

    private final MessageEndpointFactory factory_;
    private final ActivationSpec as_;
    
    /**
     * @param fac <code>MessageEndpointFactory</code>
     * @param as <code>ActivationSpec</code>
     */
    MessageEndpointFactoryInfo (MessageEndpointFactory fac, ActivationSpec as)
    {
        factory_ = fac;
        as_ = as;
    }
    
    /**
     * @return <code> MessageEndpointFactory</code> object.
     */
    public MessageEndpointFactory getEndpointFactory()
    {
        return this.factory_;
    }
    
    /**
     * @return <code>ActivationSpec</code> object.
     */
    public ActivationSpec getActivationSpec()
    {
        return this.as_;
    }
}
