/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * AutoDeployConstants.java
 *
 * Created on February 27, 2003, 12:00 AM
 */

package com.sun.enterprise.deployment.autodeploy;

/**
 *constants detail
 *
 * @author  vikas
 */
public class AutoDeployConstants {
    
    /**
     * Starting delay between AutoDeployTask activation and actual deployment.
     */
    public static  final long STARTING_DELAY=30; //sec
    /**
     * Max tardiness between schedule and actual execution of task.
     */
    public static  final long MAX_TARDINESS= 10; //sec 
    /**
     * Max tardiness between schedule and actual execution of task.
     */
    public static  final long MIN_POOLING_INTERVAL= 2; //sec

    /**
     * Default autodeploy dir set to "autodeploy" relative to server root
     */
    public static final String DEFAULT_AUTODEPLOY_DIR = "autodeploy";

    /**
     * Default polling interval set to 2sec
     */
    public static final long DEFAULT_POLLING_INTERVAL = 2; //sec

    /**
     * Extension of file, after successful deployment
     */
    public static  final String DEPLOYED="_deployed";
    /**
     * Extension of file, if deployment fails
     */
    public static  final String NOTDEPLOYED="_notdeployed";

/**
     * common deploy action
     */
    public static final String DEPLOY_METHOD       = "deploy";
    /**
     * common undeploy action
     */
    public static final String UNDEPLOY_METHOD       = "undeploy";

    public static final String DEPLOY_FAILED       = "_deployFailed";
    public static final String UNDEPLOYED       = "_undeployed";
    public static final String UNDEPLOY_FAILED       = "_undeployFailed";
    
    public static final String EAR_EXTENSION       = "ear";
    public static final String JAR_EXTENSION       = "jar";
    public static final String WAR_EXTENSION       = "war";
    public static final String RAR_EXTENSION       = "rar";
    public static final String ALL_EXTENSION       = "all";
    public static final String ZIP_EXTENSION       = "zip";
        
}
