/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Class.java
 *
 * Created on February 27, 2003, 3:53 PM
 */

package com.sun.enterprise.deployment.autodeploy;

/**
 *Interface defining autodeployment service.</br>
 *
 * With getters/setters for all the config param for auto deploy.</br>
 * Config parms are polling interval(long), verify(boolean), multiple source directory(String)</br>
 * Also the method for start(enable) and stop(disable) auto deployment service.
 *
 * @author vikas
 */
public interface AutoDeployController {
    
    public boolean enableAutoDeploy();
    
    public boolean disableAutoDeploy();
    
    public String[] getAllAutoDeployDirs();
    
    public void addAutoDeployDir(String autodeployDir) throws AutoDeploymentException;
    
    public void removeAutoDeployDir(String autodeployDir);
    
    public long getPollingInterval();
    public void setPollingInterval(long pollInterval) throws AutoDeploymentException;
    
    public boolean isVerifyEnabled();
    
    public void setVerify(boolean verify);
    
    public boolean isPreJspCompilationEnabled();
    
    public void setPreJspCompilation(boolean preJspCompilation);
    
    
}
