/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.autodeploy;

import java.io.File;
import javax.management.MBeanServer;
import javax.management.ObjectName;

/**
 * Handles all the mbean operations.
 *
 * @author binod@dev.java.net
 */
class JBIDeployer {

    private String PREFIX = "com.sun.jbi:Target=server,ServiceName=";
    private String DEPLOY_SUFFIX = "DeploymentService,ServiceType=Deployment";
    private String SHUTDOWN = "ShutDown";
    private String STARTED = "Started";
    private String STOPPED = "Stopped";
    private String NOTFOUND = "NotFound";

    /**
     * Get the status of the service assembly, if it is present undeploy it
     * first. Later deploy ant start the new archive.
     */
    void deploy(MBeanServer mbs, File sa, String saName) throws Exception {
        if (!getState(mbs, saName).equals(NOTFOUND) ) {
            undeploy(mbs, saName);
        }
        ObjectName deployMbean = getObjectName(mbs);
        mbs.invoke(deployMbean, "deploy", new Object[] {sa.getAbsolutePath()},
                   new String[] {"java.lang.String"});
        start(mbs, saName);
    }

    /**
     * Return the state of the service assembly. If it is not found return
     * NOTFOUND.
     */
    String getState(MBeanServer mbs, String sa) throws Exception {
        String state = NOTFOUND;
        try {
            ObjectName deployMbean = getObjectName(mbs);
            state = (String) mbs.invoke(deployMbean, "getState", 
            new Object[] {sa}, new String[] {"java.lang.String"});
        } catch (Exception e) {
            //sLogger.log(Level.FINE, e.getMessage(), e);
        }
        return state;
    }

    /**
     * Undeploy the archive. Before doing that, if it is started, stop it.
     * If it is stopped, shutdown it.
     */
    void undeploy(MBeanServer mbs, String sa) throws Exception {
        if (STARTED.equals(getState(mbs, sa))) {
            stop(mbs, sa);
            shutdown(mbs, sa);
        }
        if (STOPPED.equals(getState(mbs, sa))) {
            shutdown(mbs, sa);
        }
        ObjectName deployMbean = getObjectName(mbs);
        mbs.invoke(deployMbean, "undeploy", new Object[] {sa},
                   new String[] {"java.lang.String"});
    }

    private void shutdown(MBeanServer mbs, String sa) throws Exception {
        ObjectName deployMbean = getObjectName(mbs);
        mbs.invoke(deployMbean, "shutDown", new Object[] {sa},
                   new String[] {"java.lang.String"});
    }

    private void stop(MBeanServer mbs, String sa)  throws Exception {
        ObjectName deployMbean = getObjectName(mbs);
        mbs.invoke(deployMbean, "stop", new Object[] {sa},
                   new String[] {"java.lang.String"});
    }

    private void start(MBeanServer mbs, String sa)  throws Exception {
        ObjectName deployMbean = getObjectName(mbs);
        mbs.invoke(deployMbean, "start", new Object[] {sa},
                   new String[] {"java.lang.String"});
    }

    private ObjectName getObjectName(MBeanServer mbs) throws Exception {
        ObjectName deployMbean = new ObjectName(PREFIX + DEPLOY_SUFFIX);
        return mbs.getObjectInstance(deployMbean).getObjectName();
    }


}
