/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeployableObjectType.java
 *
 * Created on December 11, 2001, 10:05 AM
 */

package com.sun.enterprise.deployment.backend;

/**
 *
 * @author  bnevins
 * @version 
 */
public final class DeploymentCommand 
{
	private DeploymentCommand(String name) 
	{
		this.name = name;
	}
	
	///////////////////////////////////////////////////////////////////////////

	public static DeploymentCommand valueOf(String s)
	{
		if(s.equals(DEPLOY.toString()))
			return DEPLOY;
		if(s.equals(UNDEPLOY.toString()))
			return UNDEPLOY;
		if(s.equals(REDEPLOY.toString()))
			return REDEPLOY;

		return null;
	}
	

	///////////////////////////////////////////////////////////////////////////

	public String toString()
	{
		return name;
	}

	///////////////////////////////////////////////////////////////////////////
	
	public static final 	DeploymentCommand	DEPLOY		= new DeploymentCommand("Deploy");
	public static final	DeploymentCommand	UNDEPLOY	= new DeploymentCommand("Undeploy");
	protected static final	DeploymentCommand	REDEPLOY	= new DeploymentCommand("Redeploy");
	private				String				name;
}

