/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DeploymentEventListener.java
 *
 * Created on April 8, 2003.
 */

package com.sun.enterprise.deployment.backend;

import java.util.EventListener;

/**
 * A <code>DeploymentEventListener</code> registers itself with the 
 * <code>DeploymentEventManager</code> and processes <code>DeploymentEvent</code> 
 * events whenever they are delivered.
 *
 * @author Marina Vatkina
 */
public interface DeploymentEventListener 
    extends EventListener
{
    /**
     * This method is called when a <code>DeploymentEventManager</code>
     * needs to deliver a code>DeploymentEvent</code> event.
     * @param event the DeploymentEvent to be delivered.
     */
    void notifyDeploymentEvent(DeploymentEvent event);

}

