/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventType;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.util.DeploymentProperties;

import com.sun.enterprise.resource.Resource;
import com.sun.enterprise.resource.ResourcesXMLParser;
import com.sun.enterprise.util.i18n.StringManager;

import java.util.List;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This class manages the creation of the resources from 
 * sun-resource.xml that need to created prior to resource adapter loading
 */
public class PreResCreationPhase extends ResourcePhase {

    /** Deployment Logger object for this class */
    public static final Logger sLogger = DeploymentLogger.get();
    
    /** string manager */
    private static StringManager localStrings =
        StringManager.getManager(PreResCreationPhase.class);
   
    /** 
     * Creates a new instance of PreResCreationPhase 
     * @param deploymentCtx context object for the deployment
     */
    public PreResCreationPhase(DeploymentContext deploymentCtx) 
    {
        this.deploymentCtx = deploymentCtx;        
        this.name = PRE_RES_CREATION;
    }

    /**
     * Phase specific execution logic will go in this method.
     * Any phase implementing
     * this class will provide its implementation for this method.
     * @param req Deployment request object
     * @param phaseCtx the DeploymentPhaseContext object
     */
    public void runPhase(DeploymentPhaseContext phaseCtx)
    {
        DeploymentStatus status = phaseCtx.getDeploymentStatus();

        try {
            DeploymentRequest req = phaseCtx.getDeploymentRequest();
                                                                      
            prePhaseNotify(getPrePhaseEvent(req));
            doResourceOperation(req);
            postPhaseNotify(getPostPhaseEvent(req));
                                                                      
            phaseCtx.getDeploymentStatus().setStageStatus(DeploymentStatus.SUCCESS);
        } catch(Exception e) {
            status.setStageStatus(DeploymentStatus.WARNING);
            status.setStageException(e);
            status.setStageStatusMessage(e.getMessage());
        }
    }

   /**
     * Event that will be broadcasted at the start of the phase
     * @param req Deployment request object
     * @return DeploymentEvent
     */
    private DeploymentEvent getPrePhaseEvent(DeploymentRequest req)
    {
        return new DeploymentEvent(DeploymentEventType.PRE_RES_CREATE, new DeploymentEventInfo(req));
    }
                                                                      
    /**
     * Event that will be broadcasted at the end of the phase
     * @return DeploymentEvent
     */
    private DeploymentEvent getPostPhaseEvent(DeploymentRequest req)    {
        return new DeploymentEvent(DeploymentEventType.POST_RES_CREATE, new DeploymentEventInfo(req));
    }

    // redeployment for resource creation phase is same as deployment
    public void handleRedeployment(List<String> targetList,
        List<Resource> resourceList) throws Exception {
        handleDeployment(targetList, resourceList);
    }
                                                                      
    public List<Resource> getRelevantResources(List<Resource> allResources) {
        return ResourcesXMLParser.getNonConnectorResourcesList(allResources, true);
    }
}
