/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.collect;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.util.FileUtils;
import com.sun.logging.LogDomains;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author mu125243
 */
public class CustomerInputCollector implements Collector{

    String customerInputFile;
    String customerInput;
    String intermediateReportLocation;
    boolean local;

    protected static final Logger logger =
            LogDomains.getLogger(LogDomains.ADMIN_LOGGER);

    /** Creates a new instance of CustomerInputCollector */
    public CustomerInputCollector(String customerInputFile , String customerInput,
            String intermediateReportLocation, boolean local) {
       this.intermediateReportLocation = intermediateReportLocation;
       this.customerInput = customerInput;
       this.customerInputFile = customerInputFile;
       this.local = local;
    }

    public Data capture() throws DiagnosticException {
        if(customerInputFile != null)
            return copyCustomerInputFile(customerInputFile);
        if(customerInput != null && customerInput.trim().length() > 0) {
            WritableDataImpl customerInfo = new WritableDataImpl(DataType.CUSTOMER_INFO);
            customerInfo.addValue(customerInput);
            return customerInfo;
        }
        return null;
    }

    /**
     * Copies customer input
     * @param inputFile name of file to be copied.
     */
    private Data copyCustomerInputFile(String inputFile) {
        if(inputFile != null) {
            try {
                String destFile = intermediateReportLocation +
                        Defaults.CUSTOMER_INPUT;
                FileUtils.copyFile(inputFile, destFile);
                return new FileData(destFile,
                        DataType.CUSTOMER_INFO);
            } catch (IOException ioe) {
                logger.log(Level.WARNING, "diagnostic-service.copy_failed",
                        new Object[]{inputFile, ioe.getMessage()});
            }
        }
        return null;
    }

}
