package com.sun.enterprise.iiop;

import java.util.Map;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

import com.sun.logging.LogDomains;

public class SFSBClientVersionManager
    implements SFSBVersionConstants {

    private static final Logger _logger =
        LogDomains.getLogger(LogDomains.EJB_LOGGER);
    
    private static Map<Long, Map<Object, Long>> id2Map
        = new HashMap<Long, Map<Object, Long>>();
    
    public static synchronized long getClientVersion(long containerId, Object oid) {
        Map<Object, Long> map = id2Map.get(new Long(containerId));
        long version = NO_VERSION;
        if (map != null) {
            Long vv = map.get(oid);
            version = (vv != null) ? vv : NO_VERSION;
        }
        
        return version;
    }

    public static synchronized void setClientVersion(long containerId,
            Object oid, long version) {
        if (version != NO_VERSION) {
            Map<Object, Long> map = id2Map.get(new Long(containerId));
            if (map == null) {
                map = new HashMap<Object, Long>();
                id2Map.put(new Long(containerId), map);
            }

            
            Long existingVersion = map.get(oid);
            
            if ((existingVersion == null) || (version > existingVersion)) {
                map.put(oid, version);
            }
        }
    }
    
    public static void removeAllEntries(long containerId) {
        id2Map.remove(containerId);
    }
}
