/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.iiop.security;

/* Import classes generated from CSIV2 idl files */
import com.sun.corba.ee.org.omg.CSI.*;
import com.sun.corba.ee.org.omg.GSSUP.*;
import java.util.logging.*;
import com.sun.logging.*;

/**
 * This class contains the utility methods for dealing with
 * service contexts.
 *
 * @author: Sekhar Vajjhala
 *
 */

public class SvcContextUtils {

    private static java.util.logging.Logger _logger=null;
    static{
       _logger=LogDomains.getLogger(LogDomains.CORBA_LOGGER);
        }
    /** 
     * Define minor codes for errors specified in section 4.5,
     * "ContextError Values and Exceptions"
     * 
     * Currently only MessageInContextMinor code is defined since this
     * is the only used by the security interceptors.
     */

    public static final int MessageInContextMinor = 4 ;


    /** 
     *  Hard code the value of 15 for SecurityAttributeService until
     *  it is defined in IOP.idl.
     *     sc.context_id = SecurityAttributeService.value;
     */
    private static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;

    /**
     * Define mnemonic strings for SAS message types for debugging
     * purposes.
     */

    private static final String  EstablishContextName  = "EstablishContext";
    private static final String  CompleteEstablishName = "CompleteEstablishContext";
    private static final String  MessageInContextName  = "MessageInContext";
    private static final String  ContextErrorName      = "ContextError";

    /**
     * returns a mnemonic name for the message type based on the 
     * SASContextBody union discriminant 
     */

    public static String getMsgname(short discr) {
  
        String name = null;

        switch (discr) {

        case MTEstablishContext.value:
            name = EstablishContextName;
            break;

        case MTContextError.value:
            name = ContextErrorName;
            break;
 
        case MTCompleteEstablishContext.value:
            name = CompleteEstablishName;
            break;

        case MTMessageInContext.value:
            name = MessageInContextName;
            break;

        default:
		_logger.log(Level.SEVERE,"iiop.unknown_msgtype");
            break;  
	}
        return name;
    }
}
        


