/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.naming.factory;

import java.util.*;
import javax.naming.*;
import javax.naming.spi.*;

import java.util.Hashtable;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

import com.sun.enterprise.*;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.connectors.*;
import com.sun.enterprise.deployment.ConnectorDescriptor;

import java.util.logging.*;
import com.sun.logging.*;

/**
 * An object factory to handle creation of Connection Factories
 * 
 * @author Tony Ng
 *
 */
public class ConnectorObjectFactory implements ObjectFactory {

    static Logger _logger=LogDomains.getLogger(LogDomains.JNDI_LOGGER);

    private static LocalStringManagerImpl localStrings = 
    new LocalStringManagerImpl(ConnectorObjectFactory.class);
    private ConnectorRuntime runtime = ConnectorRuntime.getRuntime();

    public ConnectorObjectFactory() {
    }

    public Object getObjectInstance(Object obj, 
				    Name name, 
				    Context nameCtx,
				    Hashtable env) throws Exception 
    {
	Reference ref = (Reference) obj;
	if(_logger.isLoggable(Level.FINE)) {
	    _logger.log(Level.FINE,"ConnectorObjectFactory: " + ref +
			" Name:" + name);
	}
        String poolName = (String) ref.get(0).getContent();
        String moduleName  = (String) ref.get(1).getContent();

        Switch sw = Switch.getSwitch();

        if(runtime.getEnviron() == ConnectorRuntime.CLIENT) {
            ConnectorDescriptor connectorDescriptor = null; 
            try {	     
    	        Context ic = new InitialContext();        		
                String descriptorJNDIName = ConnectorAdminServiceUtils.
                    getReservePrefixedJNDINameForDescriptor(moduleName);
        		connectorDescriptor = (ConnectorDescriptor)ic.lookup(descriptorJNDIName); 
            }
            catch(NamingException ne) {
                _logger.log(Level.FINE,
			    "Failed to look up ConnectorDescriptor from JNDI", 
			    moduleName); 
                throw new ConnectorRuntimeException(
			    "Failed to look up ConnectorDescriptor from JNDI");
            }
            runtime.createActiveResourceAdapter(connectorDescriptor,
						moduleName,null);
        }

        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (runtime.checkAccessibility(moduleName, loader) == false) {
	    throw new NamingException(
		      "Only the application that has the embedded resource" + 
		      "adapter can access the resource adapter");
	}
	

        ManagedConnectionFactory mcf = runtime.obtainManagedConnectionFactory(poolName);
        if(mcf == null) {
                _logger.log(Level.FINE,"Failed to create MCF ",poolName);
                throw new ConnectorRuntimeException("Failed to create MCF");
        }

        String jndiName = name.toString();
        boolean forceNoLazyAssoc = false;
        if ( jndiName.endsWith( ConnectorConstants.PM_JNDI_SUFFIX ) ) {
            forceNoLazyAssoc = true;
        }
        ConnectionManagerImpl mgr = (ConnectionManagerImpl) 
            runtime.obtainConnectionManager(poolName, forceNoLazyAssoc);
        mgr.setJndiName(deriveJndiName(jndiName, env));
        mgr.setRarName( moduleName );
        mgr.initialize();

        Object cf = mcf.createConnectionFactory(mgr);
        if (cf == null) {
            String msg = localStrings.getLocalString
                ("no.resource.adapter", "");
            throw new ConfigurationException(msg);
        }
	if(_logger.isLoggable(Level.FINE)) {
	    _logger.log(Level.FINE,"Connection Factory:" + cf);
	}

	return cf;
    }

    private String deriveJndiName(String name, Hashtable env) {
        String suffix = (String) env.get(ConnectorConstants.JNDI_SUFFIX_PROPERTY);
        if (runtime.isValidJndiSuffix(suffix)) {
            _logger.log(Level.FINE, "JNDI name will be suffixed with :" + suffix);
            return name + suffix;
        }
        return name;
    }

}
