/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.resource;

import com.sun.enterprise.ManagementObjectManager;
import com.sun.enterprise.server.ResourceDeployer;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.AdminObjectResource;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.repository.IASJ2EEResourceFactoryImpl;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.*;

/**
  * @author    Srikanth P
  */

public class AdminObjectResourceDeployer extends GlobalResourceDeployer
        implements ResourceDeployer {

    static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);

    /**
     * Deploy the resource into the server's runtime naming context
     *
     * @param resource a resource object (eg. AdminObjectResource)
     * @exception Exception thrown if fail
     */
    public synchronized void deployResource(Object resource) throws Exception {

        final AdminObjectResource aor = 
           (com.sun.enterprise.config.serverbeans.AdminObjectResource)resource;
        final ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        
        if (aor.isEnabled()) {
            //registers the jsr77 object for the mail resource deployed
            final ManagementObjectManager mgr = 
                getAppServerSwitchObject().getManagementObjectManager();
            mgr.registerAdminObjectResource(aor.getJndiName(), 
                aor.getResAdapter(), aor.getResType(), 
                getPropNamesAsStrArr(aor.getElementProperty()), 
                getPropValuesAsStrArr(aor.getElementProperty()));
        } else {
                _logger.log(Level.INFO, "core.resource_disabled",
                        new Object[] {aor.getJndiName(),
                        IASJ2EEResourceFactoryImpl.JMS_RES_TYPE});
        }
        
        _logger.log(Level.FINE,
            "Calling backend to add adminObject",aor.getJndiName());
        crt.addAdminObject(null,aor.getResAdapter(),aor.getJndiName(),
                aor.getResType(),transformProps(aor.getElementProperty()));
        _logger.log(Level.FINE,
            "Added adminObject in backend",aor.getJndiName());
    }
    
    /**
     *d
     */
    public synchronized void undeployResource(Object resource) 
                        throws Exception {

        final AdminObjectResource aor = 
           (com.sun.enterprise.config.serverbeans.AdminObjectResource)resource;
        final ConnectorRuntime crt = ConnectorRuntime.getRuntime();
        
        _logger.log(Level.FINE,
                   "Calling backend to delete adminObject",aor.getJndiName());
        crt.deleteAdminObject(aor.getJndiName());
        _logger.log(Level.FINE,
                   "Deleted adminObject in backend",aor.getJndiName());
        
        //unregister the managed object
        final ManagementObjectManager mgr =
                getAppServerSwitchObject().getManagementObjectManager();
        mgr.unregisterAdminObjectResource(aor.getJndiName(), aor.getResType());

    }

    public synchronized void redeployResource(Object resource) 
                        throws Exception {
    }

    public synchronized void disableResource(Object resource) 
                        throws Exception {

    }

    public synchronized void enableResource(Object resource) 
                        throws Exception {
    }

    public Object getResource(String name, Resources rbeans) 
                        throws Exception {
        Object res = rbeans.getAdminObjectResourceByJndiName(name);

        if (res == null) {
            Exception ex = new Exception("No such resource");
            _logger.log(Level.SEVERE,"no_resource",name);
            _logger.log(Level.SEVERE,"",ex);
            throw ex;
        }

        return res;
    }

    Properties transformProps(ElementProperty[] domainProps) {
             
        Properties props = new Properties();
        for (ElementProperty domainProp : domainProps) {
            props.setProperty(domainProp.getName(), domainProp.getValue());
        }
        return props;
    }
}
