/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.resource;

import javax.transaction.xa.XAResource;
import javax.resource.spi.*;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import java.util.logging.*;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.PoolManager;

/**
 * @author Tony Ng
 */
public class LocalTxConnectorAllocator extends AbstractConnectorAllocator {


    public LocalTxConnectorAllocator(PoolManager poolMgr,
                                     ManagedConnectionFactory mcf,
                                     ResourceSpec spec,
                                     Subject subject,
                                     ConnectionRequestInfo reqInfo,
                                     ClientSecurityInfo info,
                                     ConnectorDescriptor desc) {
        super(poolMgr, mcf, spec, subject, reqInfo, info, desc);
    }

    
    public ResourceHandle createResource()
         throws PoolingException {
        try {
            ManagedConnection mc =
                mcf.createManagedConnection(subject, reqInfo);
            
            ResourceHandle resource =
                new ResourceHandle(mc, spec, this, info);
            ConnectionEventListener l = 
                new LocalTxConnectionEventListener(resource);
            mc.addConnectionEventListener(l);
            resource.setListener(l);

            XAResource xares = 
                new ConnectorXAResource(resource, spec, this, info);
            resource.fillInResourceObjects(null, xares);

            return resource;
        } catch (ResourceException ex) {
            _logger.log(Level.WARNING,"poolmgr.create_resource_error",ex.getMessage());
            _logger.log(Level.FINE,"Resource Exception while creating resource",ex);

            if (ex.getLinkedException() != null) {
                _logger.log(Level.WARNING,"poolmgr.create_resource_error",ex.getLinkedException().getMessage());
            }
            throw new PoolingException(ex);
        } 
    }

    public void fillInResourceObjects(ResourceHandle resource)
            throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection) resource.getResource();

            Object con = mc.getConnection(subject, reqInfo);

            ConnectorXAResource xares = (ConnectorXAResource) resource.getXAResource();
            xares.setUserHandle(con);
            resource.fillInResourceObjects(con, xares);
        } catch (ResourceException ex) {
            throw new PoolingException(ex);
        }
    }

    public void destroyResource(ResourceHandle resource)
            throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection) resource.getResource();
            ConnectorXAResource.freeListener(mc);
            mc.destroy();
            if (_logger.isLoggable( Level.FINEST ) ) {
                _logger.finest( "destroyResource for LocalTxConnectorAllocator done");
            }

        } catch (Exception ex) {
            _logger.log(Level.WARNING, ex.getMessage());
            throw new PoolingException(ex);
        }
    }

   
    public boolean shareableWithinComponent() {
        //For local transactions, a resource is always shareable within components 
	    //within the same transaction
        return true;
    }

}
