/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.resource;

public class ResourceState {
        private boolean enlisted;
        private boolean busy;
        private long timestamp;

      //Commented from 9.1 as it is not used
      /*  // This identifies the resource as new (never given out from the pool)
        // used for setting isolation level on new connections

        // init isNew to true
        private boolean isNew = true;*/


        public boolean isEnlisted() {
            return enlisted;
        }
        
        public boolean isUnenlisted() {
            return !enlisted;
        }
        
        public boolean isFree() {
            return !busy;
        }
        
        public void setEnlisted(boolean enlisted) {
            this.enlisted = enlisted;
        }
        
        public boolean isBusy() {
            return busy;
        }
        
        public void setBusy(boolean busy) {
            this.busy = busy;
        }
        
        public long getTimestamp() {
            return timestamp;
        }
        
        public void touchTimestamp() {
            timestamp = System.currentTimeMillis();
        }
        
        public ResourceState() {
            touchTimestamp();
        }

        //Commented from 9.1 as it is not used
        /*public boolean isNew() {
            return isNew;
        }

        // There's not way to set isNew to true,
        // There's no way to revert a state to new
        public void setNotNew() {
            isNew = false;
        }*/

        public String toString() {
            return "Enlisted :" + enlisted + " Busy :" + busy;
        }
}
